<?php
	$this->layout = 'standard';
	$this->pageTitle = Yii::app()->name . ' - Inicio';
	$this->breadcrumbs = array('Visitas',);
    
    $form = $this->beginWidget('CActiveForm', array(
    	'id' => 'visita-query-form',
		'action'=>Yii::app()->createUrl($this->route),
		'method'=>'post',
    	'enableClientValidation'=>true,
	));

?>
<script type="text/javascript" src="<?php echo Yii::app()->baseUrl; ?>/js/jquery.dateFormat-1.0.js"></script>
<script type="text/javascript">
<!--
$(document).ready(function() {
	$('ul.yiiPager > li > a').click(function() {
		//alert($(this).attr('href'));
		//alert($('#visita-query-form').attr('action'));
		//alert(location.href);
		var strHref = location.href;
		var strSubHrefPattern = $(this).attr('href');
		var intDiffLength = strHref.length -  strSubHrefPattern.length;
		if (!(intDiffLength >= 0 && strHref.lastIndexOf(strSubHrefPattern) === intDiffLength)) {
			$('#visita-query-form').attr('action', $(this).attr('href'));
			$("#btBuscarVisitas").click();
		}
		return false;
	});

	$('table.items > thead > tr > th > a').click(function() {
		$('#visita-query-form').attr('action', $(this).attr('href'));
		$("#btBuscarVisitas").click();
		return false;
	});
});

function ajaxGrabarHoraSalida() {
	var strHora = prompt("Hora de Salida", $.format.date(new Date(), 'HH:mm'));
	if (strHora != '' && strHora != null) {
		//recolectar los checks del listado...
		var arrCheckers = $("input[name='chk_id_visita[]']:checked");
		if (arrCheckers.length > 0) {
			var arrData = { 'chk_id_visita[]' : [], 'ho_salida': ''};
			arrData['ho_salida']= strHora;
			arrCheckers.each(function() {
				arrData['chk_id_visita[]'].push($(this).val());
			});

			$.ajax({
			     type: "POST",
			     url: "<?php echo Yii::app()->createUrl('/recepcion/visitaDetalle/updateItemSalidaVisita'); ?>",
			     async: false,
			     data: arrData,
			 	 dataType: "json",
			 	 success: function(data) {
					if (data != null) {
						alert(data.message);
						$("#btBuscarVisitas").click();
					}
			 	 },
			 	 error: function(jqXHR, textStatus, errorThrown) {
				 	var data = jQuery.parseJSON(jqXHR.responseText);
					if (data != null) {
						alert(data.message);
					}
			 	 },
			});
		}
		else {
			alert("Seleccione un registro de visita para asignarle la hora de salida. Verifique.");
		}
	}
}

//-->
</script>
<h3>Seguimiento de Visitas</h3>
<table width="100%" id="visitaBuscarTabla" class="form">
  <tr>
  	<td colspan="2">
    <?php echo $form->labelEx($visitaQueryForm, 'feInicio'); ?>: 
    <?php
            $this->widget('zii.widgets.jui.CJuiDatePicker', array(
                //'name'=>'date',
                'model' 		=> $visitaQueryForm,
                'attribute' 	=> 'feInicio',
                'language'		=>	Yii::app()->language == 'es' ? 'es' : null,
                'options'		=>	array(
                    'changeMonth'		=>	'true',
                    'changeYear'		=>	'true',
                    'yearRange'			=>	'-10:+1',
                    'showAnim'			=>	'fold', // 'show' (the default), 'slideDown', 'fadeIn', 'fold'
                    'showOn'			=>	'button', // 'focus', 'button', 'both'
                    'dateFormat'		=>	'dd/mm/yy',
                    /*'value'				=>	date('dd/mm/yyyy'),*/
                    /*'theme'=>'redmond',*/
                    'buttonText' 		=>	Yii::t('ui','Seleccionar Fecha'), 
                    'buttonImage'		=>	Yii::app()->request->baseUrl.'/images/calendar_icon-16.png', 
                    'buttonImageOnly'	=>	true,
                	'showButtonPanel'	=>	true,
                ),
                'htmlOptions'	=>	array(
                    /*'style'=>'vertical-align:top',*/
                    'class'=>'span2',
                	'readonly'=>'true',
                	'size' => 11,
                	'maxlength' => 10,
                ),
    		));
    ?>
    <?php echo $form->error($visitaQueryForm,'feInicio'); ?>
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
    <?php echo $form->labelEx($visitaQueryForm, 'feTermino'); ?>:
    <?php
            $this->widget('zii.widgets.jui.CJuiDatePicker', array(
                //'name'=>'date',
                'model' 		=> $visitaQueryForm,
                'attribute' 	=> 'feTermino',
                'language'		=>	Yii::app()->language == 'es' ? 'es' : null,
                'options'		=>	array(
                    'changeMonth'		=>	'true',
                    'changeYear'		=>	'true',
                    'yearRange'			=>	'-10:+1',
                    'showAnim'			=>	'fold', // 'show' (the default), 'slideDown', 'fadeIn', 'fold'
                    'showOn'			=>	'button', // 'focus', 'button', 'both'
                    'dateFormat'		=>	'dd/mm/yy',
                    /*'value'				=>	date('dd/mm/yyyy'),*/
                    /*'theme'=>'redmond',*/
                    'buttonText' 		=>	Yii::t('ui','Seleccionar Fecha'), 
                    'buttonImage'		=>	Yii::app()->request->baseUrl.'/images/calendar_icon-16.png', 
                    'buttonImageOnly'	=>	true,
                	'showButtonPanel'	=>	true,
                ),
                'htmlOptions'	=>	array(
                    /*'style'=>'vertical-align:top',*/
                    'class'=>'span2',
                	'readonly'=>'true',
                	'size' => 11,
                	'maxlength' => 10,
                ),
    		));
    ?>
    <?php echo $form->error($visitaQueryForm,'feTermino'); ?>
    </td>
  </tr>
  <tr>
    <td>
    <fieldset><legend>Datos del Visitante:</legend>
    <table width="100%">
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'nuDocumento'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'nuDocumento', array('size'=>15, 'maxlength'=>20,)); ?>
        	<?php echo $form->error($visitaQueryForm, 'nuDocumento'); ?>
        </td>
      </tr>
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'noInvitado'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'noInvitado', array('size'=>30, 'maxlength'=>45,)); ?>
        	<?php echo $form->error($visitaQueryForm, 'noInvitado'); ?>
        </td>
      </tr>
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'apInvitado'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'apInvitado', array('size'=>50, 'maxlength'=>90,)); ?>
        	<?php echo $form->error($visitaQueryForm, 'apInvitado'); ?>
        </td>
      </tr>
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'noInstitucion'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'noInstitucion', array('size'=>50, 'maxlength'=>150,)); ?>
        	<?php echo $form->error($visitaQueryForm, 'noInstitucion'); ?>
        </td>
      </tr>
    </table>
    </fieldset>
    </td>
    <td>
    <fieldset><legend>Datos del Empleado Público:</legend>
    <table width="100%">
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'noColaborador'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'noColaborador', array('size'=>30, 'maxlength'=>45,)); ?>
        </td>
      </tr>
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'apColaborador'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'apColaborador', array('size'=>50, 'maxlength'=>90,)); ?>
        	<?php echo $form->error($visitaQueryForm, 'apColaborador'); ?>
        </td>
      </tr>
      <tr>
        <td><?php echo $form->labelEx($visitaQueryForm, 'noLugarReunion'); ?>:</td>
        <td>
        	<?php echo $form->textField($visitaQueryForm, 'noLugarReunion', array('size'=>50, 'maxlength'=>150,)); ?>
        	<?php echo $form->error($visitaQueryForm, 'noLugarReunion'); ?>
        </td>
      </tr>
    </table>
    </fieldset>
    </td>
  </tr>
  <tr>
  <td colspan="2" id="celdaBotonBuscar">
  		<?php echo CHtml::submitButton('Buscar', array('id' => 'btBuscarVisitas')); ?>
  		<?php echo CHtml::Button('Limpiar', array('onclick' => 'location.href = \'' . Yii::app()->createUrl('/recepcion/visitaDetalle') . '\';',)); ?>
  </td>
  </tr>
</table>
<?php 
	echo CHtml::button('Nueva Visita', array('onclick' => '$("#ifrDialogNuevaVisita").attr("src", "' . Yii::app()->createUrl('/recepcion/visitaAdder') . '"); $("#addNuevaVisita").dialog("open"); return false;')); 
	echo CHtml::button('Grabar Hora de Salida', array('onclick' => 'return ajaxGrabarHoraSalida();'));
	$this->endWidget('CActiveForm');

	/* Input dialog with Javascript callback */
	$this->beginWidget('zii.widgets.jui.CJuiDialog', array(
			'id'=>'addNuevaVisita',
			'options'	=>	array(
					'title'		=>	'Agregar Nuevas Visitas',
					'autoOpen'	=>	false,
					'modal'		=>	true,
					'width'		=>	930,
					'height'	=>	610,
					'buttons'	=>	array('Cerrar'=>'js:function(){ $(this).dialog("close"); $("#btBuscarVisitas").click();/*recargar filtro*/}',),
			),
	));
?>
		<iframe id="ifrDialogNuevaVisita" name="ifrDialogNuevaVisita" src="" width="100%" height="100%"></iframe>
<?php 
	$this->endWidget('zii.widgets.jui.CJuiDialog');
?>

<?php
	/* Input dialog with Javascript callback */
	$this->beginWidget('zii.widgets.jui.CJuiDialog', array(
			'id'=>'updateSalidaVisita',
			'options'	=>	array(
					'title'		=>	'Registro de Hora de Salida',
					'autoOpen'	=>	false,
					'modal'		=>	true,
					'width'		=>	700,
					'height'	=>	300,
					'buttons'	=>	array('Cerrar'=>'js:function(){ $(this).dialog("close");}',),
			),
	));
?>
	<iframe id="ifrSalidaVisita" name="ifrSalidaVisita" src="" width="100%" height="100%"></iframe>
<?php 
	$this->endWidget('zii.widgets.jui.CJuiDialog');
?>
<?php
	$this->echoLstVisitasResultGrid($lstVisitasResult);
?>