<?php

class VisitasForm extends CFormModel {
	
	public $idColaborador;
	public $idSede;
	public $noColaborador;
	public $noMotivo;
	public $noLugarReunion;
	public $feIngreso/* = date('d/m/Y')*/;//no funciona
	public $hoIngreso/* = date('H:i')*/;//no funciona
	public $noUsuarioResgistro;
	
	public $lstVisitaInvitados = array();//array de objetos VisitaInvitadoForm
	public $lstColaboradores = array();
	public $lstLugarReuniones = array();
	public $lstTipoMotivos = array();
	
	public function __construct() {
		$this->feIngreso = date('d/m/Y');
		$this->hoIngreso = date('H:i');
	}
	
	public function rules() {
		return array(
			// feIngreso are required
			array('idColaborador, noColaborador, noMotivo, noLugarReunion, feIngreso, hoIngreso', 'required'),
			array('noColaborador, noMotivo, noLugarReunion', 'ext.alpha', 'minChars' => 0, 'maxChars' => 150, 'allowNumbers' => true, 'allAccentedLetters' => true, 'allowSpaces' => true, 'extra' => array('\-', '_', '.', '&', '/')),
			array('idSede, noUsuarioResgistro', 'safe'),
			array('feIngreso', 'date', 'format'=>'d/M/yyyy'),
			array('feIngreso', 'checkFeIngresoToday'),
		);
	}
	
	public function checkFeIngresoToday($attribute, $params) {
		if (!$this->hasErrors()) {
			$arrFeIngreso = explode('/', $this->{$attribute});
			$intTimeTomorrow = mktime(0, 0, 0, date("n"), date("j") + 1, date("Y"));
			$intTimeFeIngreso = mktime(0, 0, 0, $arrFeIngreso[1], $arrFeIngreso[0], $arrFeIngreso[2]);
			if (!($intTimeFeIngreso < $intTimeTomorrow)) {
				$this->addError($attribute, 'La ' . $this->getAttributeLabel($attribute) . ' no puede ser una fecha futura. Verifique.');
			}
		}
	}
	
	public function attributeLabels() {
		return array(
				'idColaborador'	=>	'Id del Anfitrión',
				'noColaborador'	=>	'Nombre Completo',
				'noMotivo'		=>	'Motivo',
				'noLugarReunion'=>	'Lugar de Reunión',
				'feIngreso'		=>	'Fecha de Ingreso',
				'hoIngreso'		=>	'Hora de Ingreso',
				'idSede'		=>	'Sede',
		);
	}
}