<?php

class VisitaQueryForm extends CFormModel {
	
	public $feInicio;
	public $feTermino;
	public $nuDocumento;
	public $noInstitucion;
	public $noInvitado;
	public $apInvitado;
	public $noColaborador;
	public $apColaborador;
	public $noLugarReunion;
	public $inActivo;
	public $idSede;

	public function rules()
	{
		return array(
				// feIngreso are required
				array('idSede', 'safe'),
				array('feInicio', 'required'),
				array('feTermino', 'required'),
				array('nuDocumento', 'ext.alpha', 'minChars' => 0, 'maxChars' => 20, 'allowNumbers' => true, 'extra' => array('\-', '_', '.')),
				array('noInstitucion', 'ext.alpha', 'minChars' => 0, 'maxChars' => 150, 'allowNumbers' => true, 'allowSpaces' => true, 'allAccentedLetters' => true, 'extra' => array('\-', '_', '.')),
				array('noInvitado', 'ext.alpha', 'minChars' => 0, 'maxChars' => 45, 'allowNumbers' => true, 'allowSpaces' => true, 'allAccentedLetters' => true, 'extra' => array('\-', '_', '.')),
				array('apInvitado', 'ext.alpha', 'minChars' => 0, 'maxChars' => 90, 'allowNumbers' => true, 'allowSpaces' => true, 'allAccentedLetters' => true, 'extra' => array('\-', '_', '.')),
				array('noColaborador', 'ext.alpha', 'minChars' => 0, 'maxChars' => 45, 'allowNumbers' => true, 'allowSpaces' => true, 'allAccentedLetters' => true, 'extra' => array('\-', '_', '.')),
				array('apColaborador', 'ext.alpha', 'minChars' => 0, 'maxChars' => 90, 'allowNumbers' => true, 'allowSpaces' => true, 'allAccentedLetters' => true, 'extra' => array('\-', '_', '.')),
				array('noLugarReunion', 'ext.alpha', 'minChars' => 0, 'maxChars' => 150, 'allowNumbers' => true, 'allowSpaces' => true, 'allAccentedLetters' => true, 'extra' => array('\-', '_', '.')),
		);
	}
	
	/**
	 * Declares customized attribute labels.
	 * If not declared here, an attribute would have a label that is
	 * the same as its name with the first letter in upper case.
	 */
	public function attributeLabels()
	{
		return array(
				'feInicio'		=>'Fecha de Inicio',
				'feTermino'		=>'Fecha de Termino',
				'nuDocumento'	=>'Documento',
				'noInvitado'	=>'Nombres',
				'apInvitado'	=>'Apellidos',
				'noInstitucion'	=>'Entidad',
				'noColaborador'	=>'Nombres',
				'apColaborador'	=>'Apellidos',
				'noLugarReunion'=>'Lugar de Reunión',
		);
	}
}