<?php

class VisitaInvitadoForm extends CFormModel {
	
	//public $feInicio;
	//public $feTermino;
	//public $hoInicio;
	//public $hoTermino;
	//public $idColaborador;
	//public $noLugarReunion;
	//public $noMotivoVisita;
	public $tiDocumento;
	public $noTiDocumento;
	public $nuDocumento;
	public $noInstitucion;
	public $noInvitado;
	public $apPaternoInvitado;
	public $apMaternoInvitado;
	public $coPase;
	public $idInvitado;

	public $lstTiDocumentos;

	public function rules() {
		return array(
			// feIngreso are required
			array('noInvitado, apPaternoInvitado', 'required'),
			array('apMaternoInvitado', 'safe'),
			array('nuDocumento, tiDocumento', 'required'),
			array('noInstitucion', 'ext.alpha', 'minChars' => 0, 'maxChars' => 150, 'allowNumbers' => true, 'allAccentedLetters' => true, 'allowSpaces' => true, 'extra' => array('\-', '_', '.', '&', '/')),
			array('nuDocumento', 'ext.alpha', 'minChars' => 5, 'maxChars' => 20, 'allowNumbers' => true, 'extra' => array('\-', '_', '.')),
			array('coPase', 'ext.alpha', 'minChars' => 0, 'maxChars' => 20, 'allowNumbers' => true, 'extra' => array('\-', '_', '.')),
			array('idInvitado', 'numerical', 'integerOnly' => true, 'allowEmpty' => true,),
			array('tiDocumento', 'checkAppMaterno'),
		);
	}
	
	public function attributeLabels() {
		return array(
				'tiDocumento'	=>	'Documento',
				'noTiDocumento'	=>	'Documento',
				'nuDocumento'	=>	'Nro. Documento',
				'noInstitucion'	=>	'Entidad',
				'noInvitado'	=>	'Nombres',
				'apPaternoInvitado'	=>	'Apellido Paterno',
				'apMaternoInvitado'	=>	'Apellido Materno',
				'coPase'			=>	'Cod. Pase',
		);
	}
	
	function checkAppMaterno($attribute, $params) {
		if (!$this->hasErrors()) {
			$tiDoc = (int) $this->{$attribute};
			if ($tiDoc == 1) {//DNI
				if ($this->apMaternoInvitado == '') {
					$this->addError('apMaternoInvitado', 'El ' . $this->getAttributeLabel('apMaternoInvitado') . ' no puede ser vacio para un documento DNI. Verifique.');
				}
			}
		}
		
	}
}