<?php

/**
 * This is the model class for table "tm_visita".
 *
 * The followings are the available columns in table 'tm_visita':
 * @property integer $id_visita
 * @property integer $id_colaborador
 * @property string $no_lugar_reunion
 * @property string $no_motivo_visita
 * @property string $fe_registro
 *
 * The followings are the available model relations:
 * @property TiVisitaDetalle[] $tiVisitaDetalles
 * @property TmColaborador $idColaborador
 * @property TmLugarReunion $noLugarReunion
 */
class Visita extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Visita the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_visita';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_sede, no_lugar_reunion, no_motivo_visita, fe_registro, id_invitado, fe_ingreso, no_colaborador, ap_paterno_colaborador, ap_materno_colaborador, ti_documento_colaborador, nu_documento_colaborador', 'required'),
			array('id_sede, id_invitado, ti_documento_colaborador', 'numerical', 'integerOnly' => true),
			array('no_motivo_visita, no_lugar_reunion', 'length', 'max' => 150),
			array('no_colaborador, ap_paterno_colaborador, ap_materno_colaborador', 'length', 'max' => 45),
			array('no_oficina', 'length', 'max' => 255),
			array('co_pase, nu_documento_colaborador, no_usuario_registro, no_usuario_modificacion', 'length', 'max' => 20),
			array('fe_salida', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_visita, id_sede, no_lugar_reunion, no_motivo_visita, no_oficina, fe_registro, no_usuario_registro, no_usuario_modificacion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			/*'tiVisitaDetalles' => array(self::HAS_MANY, 'VisitaDetalle', 'id_visita'),*/
			'objInvitado' => array(self::BELONGS_TO, 'Invitado', 'id_invitado'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_visita' => 'Id de Visita',
			'no_lugar_reunion' => 'Lugar de Reunion',
			'no_motivo_visita' => 'Motivo de Visita',
			'fe_registro' => 'Fecha de Registro',
			'id_invitado' => 'Invitado',
			'co_pase' => 'Codigo de Pase',
			'fe_ingreso' => 'Fecha de Ingreso',
			'fe_salida' => 'Fecha de Salida',
			'id_sede' => 'Sede',
			'no_oficina' => 'Oficina',
			'no_usuario_registro' => 'Usuario que Registrió',
			'no_usuario_modificacion' => 'Usuario que Modificó',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_visita',$this->id_visita);
		$criteria->compare('no_lugar_reunion',$this->no_lugar_reunion);
		$criteria->compare('no_motivo_visita',$this->no_motivo_visita,true);
		$criteria->compare('fe_registro',$this->fe_registro,true);
		$criteria->compare('id_invitado',$this->id_invitado);
		$criteria->compare('co_pase',$this->co_pase,true);
		$criteria->compare('fe_ingreso',$this->fe_ingreso,true);
		$criteria->compare('fe_salida',$this->fe_salida,true);
		$criteria->compare('id_sede',$this->id_sede,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function behaviors()
	{
		return array('CMssqlDatetimeBehavior' => array('class' => 'ext.CMssqlDatetimeBehavior')); // 'ext' is in Yii 1.0.8 version. For early versions, use 'application.extensions' instead.
	}
}