<?php

/**
 * This is the model class for table "tm_usuario".
 *
 * The followings are the available columns in table 'tm_usuario':
 * @property integer $id_usuario
 * @property string $no_usuario
 * @property string $no_clave
 * @property string $no_completo_usuario
 * @property string $ap_paterno_usuario
 * @property string $ap_materno_usuario
 * @property integer $id_sede
 * @property integer $id_rol
 *
 * The followings are the available model relations:
 * @property TmSede $idSede
 * @property TmRol $idRol
 */
class Usuario extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Usuario the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_usuario';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('no_usuario, no_clave, no_completo_usuario, ap_paterno_usuario, ap_materno_usuario, id_sede, id_rol', 'required'),
			array('id_sede, id_rol', 'numerical', 'integerOnly'=>true),
			array('no_usuario', 'length', 'max'=>20),
			array('no_clave, no_completo_usuario, ap_paterno_usuario, ap_materno_usuario', 'length', 'max'=>45),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_usuario, no_usuario, no_clave, no_completo_usuario, ap_paterno_usuario, ap_materno_usuario, id_sede, id_rol, fe_login_actual, fe_login_ultimo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'objSede' => array(self::BELONGS_TO, 'Sede', 'id_sede'),
			'objRol' => array(self::BELONGS_TO, 'Rol', 'id_rol'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels() {
		return array(
			'id_usuario' => 'Id Usuario',
			'no_usuario' => 'Nombre de Usuario',
			'no_clave' => 'Clave',
			'no_completo_usuario' => 'Nombre Completo',
			'ap_paterno_usuario' => 'Apellido Paterno',
			'ap_materno_usuario' => 'Apellido Materno',
			'id_sede' => 'Sede',
			'id_rol' => 'Rol',
			'fe_login_actual' => 'Fecha Actual de Login',
			'fe_login_ultimo' => 'Fecha de Último Acceso',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('no_usuario',$this->no_usuario,true);
		$criteria->compare('no_clave',$this->no_clave,true);
		$criteria->compare('no_completo_usuario',$this->no_completo_usuario,true);
		$criteria->compare('ap_paterno_usuario',$this->ap_paterno_usuario,true);
		$criteria->compare('ap_materno_usuario',$this->ap_materno_usuario,true);
		$criteria->compare('id_sede',$this->id_sede);
		$criteria->compare('id_rol',$this->id_rol);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}