<?php

/**
 * This is the model class for table "tm_sede".
 *
 * The followings are the available columns in table 'tm_sede':
 * @property integer $id_sede
 * @property string $co_sede
 * @property string $no_sede
 * @property string $de_sede
 *
 * The followings are the available model relations:
 * @property TmColaborador[] $tmColaboradors
 * @property TmLugarReunion[] $tmLugarReunions
 */
class Sede extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Sede the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_sede';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('co_sede, no_sede', 'required'),
			array('co_sede', 'length', 'max'=>20),
			array('no_sede', 'length', 'max'=>45),
			array('de_sede', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_sede, co_sede, no_sede, de_sede', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tmColaboradors' => array(self::HAS_MANY, 'Colaborador', 'id_sede'),
			'tmLugarReunions' => array(self::HAS_MANY, 'LugarReunion', 'id_sede'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_sede' => 'Id Sede',
			'co_sede' => 'Código de Sede',
			'no_sede' => 'Nombre de la Sede',
			'de_sede' => 'Descripción de la Sede',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_sede',$this->id_sede);
		$criteria->compare('co_sede',$this->co_sede,true);
		$criteria->compare('no_sede',$this->no_sede,true);
		$criteria->compare('de_sede',$this->de_sede,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}