<?php

/**
 * This is the model class for table "tm_rol".
 *
 * The followings are the available columns in table 'tm_rol':
 * @property integer $id_rol
 * @property string $co_rol
 * @property string $no_rol
 * @property string $de_rol
 *
 * The followings are the available model relations:
 * @property TmColaborador[] $tmColaboradors
 */
class Rol extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Rol the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_rol';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('co_rol, no_rol', 'required'),
			array('co_rol', 'length', 'max'=>20),
			array('no_rol', 'length', 'max'=>45),
			array('de_rol', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_rol, co_rol, no_rol, de_rol', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tmColaboradors' => array(self::HAS_MANY, 'Colaborador', 'id_rol'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_rol' => 'Id Rol',
			'co_rol' => 'Código de Rol',
			'no_rol' => 'Nombre de Rol',
			'de_rol' => 'Descripción de Rol',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_rol',$this->id_rol);
		$criteria->compare('co_rol',$this->co_rol,true);
		$criteria->compare('no_rol',$this->no_rol,true);
		$criteria->compare('de_rol',$this->de_rol,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}