<?php

/**
 * This is the model class for table "tm_oficina".
 *
 * The followings are the available columns in table 'tm_oficina':
 * @property integer $id_oficina
 * @property integer $id_sede
 * @property string $co_oficina
 * @property string $no_oficina
 * @property string $de_oficina
 *
 * The followings are the available model relations:
 * @property TmColaborador[] $tmColaboradors
 * @property TmSede $idSede
 */
class Oficina extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Oficina the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_oficina';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_sede, co_oficina, no_oficina', 'required'),
			array('id_sede', 'numerical', 'integerOnly'=>true),
			array('co_oficina', 'length', 'max'=>25),
			array('no_oficina, de_oficina', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_oficina, id_sede, co_oficina, no_oficina, de_oficina', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tmColaboradors' => array(self::HAS_MANY, 'Colaborador', 'id_oficina'),
			'objSede' => array(self::BELONGS_TO, 'Sede', 'id_sede'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_oficina' => 'Id Oficina',
			'id_sede' => 'Sede',
			'co_oficina' => 'Código Oficina',
			'no_oficina' => 'Nombre Oficina',
			'de_oficina' => 'Descripción Oficina',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_oficina',$this->id_oficina);
		$criteria->compare('id_sede',$this->id_sede);
		$criteria->compare('co_oficina',$this->co_oficina,true);
		$criteria->compare('no_oficina',$this->no_oficina,true);
		$criteria->compare('de_oficina',$this->de_oficina,true);

		return new CActiveDataProvider($this, array('criteria'=>$criteria,));
	}
}