<?php

/**
 * This is the model class for table "tm_lugar_reunion".
 *
 * The followings are the available columns in table 'tm_lugar_reunion':
 * @property integer $id_lugar_reunion
 * @property integer $id_sede
 * @property string $no_lugar_reunion
 * @property string $de_lugar_reunion
 *
 * The followings are the available model relations:
 * @property TmSede $idSede
 * @property TmVisita[] $tmVisitas
 */
class LugarReunion extends CActiveRecord
{
	
	/*public function __construct() {
	}
	
	public function __construct($idLugarReunion, $noLugarReunion) {
		$this->id_lugar_reunion = $idLugarReunion;
		$this->no_lugar_reunion = $noLugarReunion;
	}*/
	
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return LugarReunion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_lugar_reunion';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_sede, no_lugar_reunion', 'required'),
			array('id_sede', 'numerical', 'integerOnly'=>true),
			array('no_lugar_reunion', 'length', 'max'=>45),
			array('de_lugar_reunion', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_lugar_reunion, id_sede, no_lugar_reunion, de_lugar_reunion', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'objSede' => array(self::BELONGS_TO, 'Sede', 'id_sede'),
			'tmVisitas' => array(self::HAS_MANY, 'Visita', 'id_lugar_reunion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_lugar_reunion' => 'Id Lugar Reunion',
			'id_sede' => 'Sede',
			'no_lugar_reunion' => 'Nombre del Lugar de Reunión',
			'de_lugar_reunion' => 'Descripción del Lugar de Reunión',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_lugar_reunion',$this->id_lugar_reunion);
		$criteria->compare('id_sede',$this->id_sede);
		$criteria->compare('no_lugar_reunion',$this->no_lugar_reunion,true);
		$criteria->compare('de_lugar_reunion',$this->de_lugar_reunion,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}