<?php

/**
 * This is the model class for table "tm_invitado".
 *
 * The followings are the available columns in table 'tm_invitado':
 * @property integer $id_invitado
 * @property string $no_invitado
 * @property string $ap_paterno_invitado
 * @property string $ap_materno_invitado
 * @property integer $ti_documento
 * @property string $nu_documento
 * @property string $no_entidad_representada
 *
 * The followings are the available model relations:
 * @property TiVisitaDetalle[] $tiVisitaDetalles
 */
class Invitado extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Invitado the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_invitado';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('no_invitado, ap_paterno_invitado, ti_documento, nu_documento', 'required'),
			array('ti_documento', 'numerical', 'integerOnly'=>true),
			array('no_invitado, ap_paterno_invitado, ap_materno_invitado', 'length', 'max'=>45),
			array('nu_documento', 'length', 'max'=>20),
			array('no_entidad_representada', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('ap_materno_invitado', 'safe'),
			array('id_invitado, no_invitado, ap_paterno_invitado, ap_materno_invitado, ti_documento, nu_documento, no_entidad_representada', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'objTiDoc'	=> array(self::BELONGS_TO, 'DetalleDominio', 'ti_documento'),
			'tmVisitas' => array(self::HAS_MANY, 'Visita', 'id_invitado'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_invitado' => 'Id Visitante',
			'no_invitado' => 'Nombre del Visitante',
			'ap_paterno_invitado' => 'Apellido Paterno del Visitante',
			'ap_materno_invitado' => 'Apellido Materno del Visitante',
			'ti_documento' => 'Tipo de Documento de Identidad',
			'nu_documento' => 'Número de Documento',
			'no_entidad_representada' => 'Nombre de la Entidad Representada',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_invitado',$this->id_invitado);
		$criteria->compare('no_invitado',$this->no_invitado,true);
		$criteria->compare('ap_paterno_invitado',$this->ap_paterno_invitado,true);
		$criteria->compare('ap_materno_invitado',$this->ap_materno_invitado,true);
		$criteria->compare('ti_documento',$this->ti_documento);
		$criteria->compare('nu_documento',$this->nu_documento,true);
		$criteria->compare('no_entidad_representada',$this->no_entidad_representada,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}