<?php

/**
 * This is the model class for table "tm_instituto".
 *
 * The followings are the available columns in table 'tm_instituto':
 * @property integer $id_instituto
 * @property string $no_instituto
 * @property string $de_instituto
 * @property string $nu_ruc
 */
class Instituto extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Instituto the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_instituto';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('no_instituto', 'required'),
			array('no_instituto', 'length', 'max'=>50),
			array('de_instituto', 'length', 'max'=>150),
			array('nu_ruc', 'length', 'max'=>11),
			array('nu_ruc', 'ext.alpha', 'minChars' => 0, 'maxChars' => 11, 'allowNumbers' => true,),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_instituto, no_instituto, de_instituto, nu_ruc', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_instituto' => 'Id Entidad',
			'no_instituto' => 'Nombre de la Entidad',
			'de_instituto' => 'Descripción de la Entidad',
			'nu_ruc' => 'Ruc',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_instituto',$this->id_instituto);
		$criteria->compare('no_instituto',$this->no_instituto,true);
		$criteria->compare('de_instituto',$this->de_instituto,true);
		$criteria->compare('nu_ruc',$this->nu_ruc,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}