<?php

/**
 * This is the model class for table "tm_dominio".
 *
 * The followings are the available columns in table 'tm_dominio':
 * @property integer $id_dominio
 * @property string $co_dominio
 * @property string $no_dominio
 * @property string $de_dominio
 *
 * The followings are the available model relations:
 * @property TdDetalleDominio[] $tdDetalleDominios
 */
class Dominio extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Dominio the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_dominio';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('co_dominio, no_dominio', 'required'),
			array('co_dominio', 'length', 'max'=>20),
			array('no_dominio', 'length', 'max'=>45),
			array('de_dominio', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_dominio, co_dominio, no_dominio, de_dominio', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tdDetalleDominios' => array(self::HAS_MANY, 'DetalleDominio', 'id_dominio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_dominio' => 'Id Tabla Parametro',
			'co_dominio' => 'Codigo Tabla Parametro',
			'no_dominio' => 'Nombre Tabla Parametro',
			'de_dominio' => 'Descripcion Tabla Parametro',
			'no_columna_01' => 'Nombre de la Columna 1',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_dominio',$this->id_dominio);
		$criteria->compare('co_dominio',$this->co_dominio,true);
		$criteria->compare('no_dominio',$this->no_dominio,true);
		$criteria->compare('de_dominio',$this->de_dominio,true);

		return new CActiveDataProvider($this, array('criteria'=>$criteria,));
	}
}