<?php

/**
 * This is the model class for table "td_detalle_dominio".
 *
 * The followings are the available columns in table 'td_detalle_dominio':
 * @property integer $id_detalle_dominio
 * @property integer $id_dominio
 * @property string $co_detalle_dominio
 * @property string $no_detalle_dominio
 * @property string $de_detalle_dominio
 *
 * The followings are the available model relations:
 * @property TmDominio $idDominio
 */
class DetalleDominio extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DetalleDominio the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'td_detalle_dominio';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_dominio, co_detalle_dominio, no_detalle_dominio', 'required'),
			array('id_dominio', 'numerical', 'integerOnly'=>true),
			array('co_detalle_dominio', 'length', 'max'=>20),
			array('no_detalle_dominio', 'length', 'max'=>45),
			array('de_detalle_dominio, va_columna_01', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_detalle_dominio, id_dominio, co_detalle_dominio, no_detalle_dominio, de_detalle_dominio, va_columna_01', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'objDominio' => array(self::BELONGS_TO, 'Dominio', 'id_dominio'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_detalle_dominio' => 'Id Detalle del Parametro',
			'id_dominio' 		 => 'Tabla Parametro',
			'co_detalle_dominio' => 'Codigo del Detalle Parametro',
			'no_detalle_dominio' => 'Nombre del Detalle Parametro',
			'de_detalle_dominio' => 'Descripción del Detalle Parametro',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_detalle_dominio',$this->id_detalle_dominio);
		$criteria->compare('id_dominio',$this->id_dominio);
		$criteria->compare('co_detalle_dominio',$this->co_detalle_dominio,true);
		$criteria->compare('no_detalle_dominio',$this->no_detalle_dominio,true);
		$criteria->compare('de_detalle_dominio',$this->de_detalle_dominio,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}