<?php

/**
 * This is the model class for table "tm_colaborador".
 *
 * The followings are the available columns in table 'tm_colaborador':
 * @property integer $id_colaborador
 * @property string $co_colaborador
 * @property integer $id_cargo_laboral
 * @property integer $id_sede
 * @property string $no_colaborador
 * @property string $ap_paterno_colaborador
 * @property string $ap_materno_colaborador
 * @property string $no_usuario
 * @property string $no_clave
 * @property integer $ti_documento
 * @property string $nu_documento
 *
 * The followings are the available model relations:
 * @property TmRol $idRol
 * @property TmCargoLaboral $idCargoLaboral
 * @property TmSede $idSede
 * @property TmVisita[] $tmVisitas
 */
class Colaborador extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Colaborador the static model class
	 */
	 public $no_cargo_laboral;
	 public $no_oficina;
	 
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_colaborador';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('co_colaborador, id_cargo_laboral, id_sede, no_colaborador, ap_paterno_colaborador, ap_materno_colaborador, ti_documento, nu_documento', 'required'),
			array('id_cargo_laboral, id_oficina, id_sede, ti_documento', 'numerical', 'integerOnly'=>true),
			array('co_colaborador,nu_documento', 'ext.alpha', 'minChars' => 0, 'maxChars' => 20, 'allowNumbers' => true,),
			array('co_colaborador, nu_documento', 'length', 'max'=>20),
			array('no_colaborador, ap_paterno_colaborador, ap_materno_colaborador', 'length', 'max'=>45),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_colaborador, co_colaborador, id_cargo_laboral, id_oficina, id_sede, no_colaborador, ap_paterno_colaborador, ap_materno_colaborador, ti_documento, nu_documento', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'objCargoLaboral' 	=> array(self::BELONGS_TO, 'CargoLaboral', 'id_cargo_laboral'),
			'objSede' 			=> array(self::BELONGS_TO, 'Sede', 'id_sede'),
			'objOficina'		=> array(self::BELONGS_TO, 'Oficina', 'id_oficina'),
			'objTiDoc'			=> array(self::BELONGS_TO, 'DetalleDominio', 'ti_documento'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_colaborador' => 'Id',
			'co_colaborador' => 'Código',
			'id_cargo_laboral' => 'Cargo Laboral',
			'id_sede' => 'Sede',
			'no_colaborador' => 'Nombres',
			'ap_paterno_colaborador' => 'Apellido Paterno',
			'ap_materno_colaborador' => 'Apellido Materno',
			'ti_documento' => 'Tipo de Documento de Identidad',
			'nu_documento' => 'Número de Documento de Identidad',
			'id_oficina' => 'Oficina',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria = new CDbCriteria;

		$criteria->compare('id_colaborador',$this->id_colaborador);
		$criteria->compare('co_colaborador',$this->co_colaborador,true);
		$criteria->compare('id_cargo_laboral',$this->id_cargo_laboral);
		$criteria->compare('id_sede',$this->id_sede);
		$criteria->compare('no_colaborador',$this->no_colaborador,true);
		$criteria->compare('ap_paterno_colaborador',$this->ap_paterno_colaborador,true);
		$criteria->compare('ap_materno_colaborador',$this->ap_materno_colaborador,true);
		$criteria->compare('ti_documento',$this->ti_documento);
		$criteria->compare('nu_documento',$this->nu_documento,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}