<?php

/**
 * This is the model class for table "tm_cargo_laboral".
 *
 * The followings are the available columns in table 'tm_cargo_laboral':
 * @property integer $id_cargo_laboral
 * @property string $co_cargo_laboral
 * @property string $no_cargo_laboral
 * @property string $de_cargo_laboral
 *
 * The followings are the available model relations:
 * @property TmColaborador[] $tmColaboradors
 */
class CargoLaboral extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return CargoLaboral the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_cargo_laboral';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('co_cargo_laboral, no_cargo_laboral', 'required'),
			array('co_cargo_laboral', 'length', 'max'=>20),
			array('no_cargo_laboral', 'length', 'max'=>45),
			array('de_cargo_laboral', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_cargo_laboral, co_cargo_laboral, no_cargo_laboral, de_cargo_laboral', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tmColaboradors' => array(self::HAS_MANY, 'Colaborador', 'id_cargo_laboral'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_cargo_laboral' => 'Id Cargo Laboral',
			'co_cargo_laboral' => 'Codigo Cargo Laboral',
			'no_cargo_laboral' => 'Nombre del Cargo Laboral',
			'de_cargo_laboral' => 'Descripcion del Cargo Laboral',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_cargo_laboral',$this->id_cargo_laboral);
		$criteria->compare('co_cargo_laboral',$this->co_cargo_laboral,true);
		$criteria->compare('no_cargo_laboral',$this->no_cargo_laboral,true);
		$criteria->compare('de_cargo_laboral',$this->de_cargo_laboral,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}