<?php

/**
 * This is the model class for table "tm_acceso_web".
 *
 * The followings are the available columns in table 'tm_acceso_web':
 * @property integer $id_acceso_web
 * @property integer $ti_acceso_web
 * @property string $fe_acceso_web
 * @property integer $nu_acceso_web
 */
class AccesoWeb extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AccesoWeb the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tm_acceso_web';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ti_recurso_web, fe_acceso_web, nu_acceso_web', 'required'),
			array('ti_recurso_web, nu_acceso_web', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_acceso_web, ti_recurso_web, fe_acceso_web, nu_acceso_web', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_acceso_web' => 'Id Acceso Web',
			'ti_recurso_web' => 'Tipo de Recurso Web',
			'fe_acceso_web' => 'Fecha de Acceso Web',
			'nu_acceso_web' => 'Numero de Accesos Web',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_acceso_web',$this->id_acceso_web);
		$criteria->compare('ti_recurso_web',$this->ti_recurso_web);
		$criteria->compare('fe_acceso_web',$this->fe_acceso_web,true);
		$criteria->compare('nu_acceso_web',$this->nu_acceso_web);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}