<?php

/**
 * Esto es para cambiar el comportamiento de como el driver mssql nativo del php obtiene los campos fecha del tipo datetime.
 * Se ha visto que para dichos campos el driver mssql los muestra en formato cadena del tipo M j Y g:iA, cuando se espera que devuelva
 * de la forma Y-m-d H:i:s como lo hace el drvier sqlsrv.
 * El driver mssql nativo del php solo está disponible hasta la versión 5.2 del php.
 * 
 * añadir esto
 * 	public function behaviors()
	{
		return array('CMssqlDatetimeBehavior' => array('class' => 'ext.CMssqlDatetimeBehavior')); // 'ext' is in Yii 1.0.8 version. For early versions, use 'application.extensions' instead.
	}
	en cada clase modelo que maneja campos de fecha datetime en el driver mssql
 */
class CMssqlDatetimeBehavior extends CActiveRecordBehavior {
	
	public $dateFinalFormat = 'Y-m-d';
	public $dateTimeFinalFormat = 'Y-m-d H:i:s';
	
	public $dateDbMssqlFormat = 'M j Y';
	public $dateTimeDbMssqlFormat = 'M j Y g:iA';
	
	
	public function afterFind($event) {
		
		$connection = $event->sender->getDbConnection();
		$driverName = $connection->getDriverName();
		
		if ($driverName == 'mssql') {
			foreach($event->sender->tableSchema->columns as $columnName => $column) {
					
				if (($column->dbType != 'date') and ($column->dbType != 'datetime')) continue;
					
				if (!strlen($event->sender->$columnName)) {
					$event->sender->$columnName = null;
					continue;
				}
				//error_log("tipo columna::" . $column->dbType);
				if ($column->dbType == 'datetime') {
					//error_log("valor fecha::" . $event->sender->$columnName);
					$datetimeUnix = strtotime($event->sender->$columnName);
					if ($datetimeUnix !== false) {
						$datetimeCorrejido = date($this->dateTimeFinalFormat, $datetimeUnix);
						//error_log("valor fecha correjido::" . $datetimeCorrejido);
						$event->sender->$columnName = $datetimeCorrejido;
					}
				}
				/*else if ($column->dbType == 'date') {
					
				}*/
			}
		}
		
		return true;
	}
}