<?php

class VisitaDetalleController extends Controller
{
	public $layout='//layouts/standard';
	
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
				'accessControl', // perform access control for CRUD operations
		);
	}
	
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
				/*array('allow',  // allow all users to perform 'index' and 'view' actions
						'actions' => array('view'),
						'users' => array('*'),
				),*/
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('index', 'deleteItemVisitaResultGrid', 'updateItemSalidaVisita'/*, 'logicalDelete', 'update'*/),
						'users' => array('@'),
						'roles' => array('RECEPCION'),
				),
				array('deny',  // deny all users
						'users' => array('*'),
				),
		);
	}
	
	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		$visitaQueryForm = new VisitaQueryForm();
		$cvisita = new CVisita();
		if(isset($_POST['ajax']) && $_POST['ajax'] === 'visita-query-form') {
			error_log('aca ajax!!');
		}
		else if (isset($_POST['VisitaQueryForm'])) {
			/*$request = Yii::app()->request;
			$form = $request->getPost('VisitaQueryForm');*/
			$visitaQueryForm->setAttributes($_POST['VisitaQueryForm']);
			$visitaQueryForm->inActivo = 7;//solo activos
			$visitaQueryForm->idSede = Yii::app()->user->id_sede;
			if ($visitaQueryForm->validate()) {
				//error_log('aca post::' . print_r($_POST['VisitaQueryForm'], true));
				//error_log('aca post::' . print_r($visitaQueryForm, true));
				/*error_log('aca post FORM REQUEST::' . print_r($form, true));*/
				$lstVisitasResult =  new CArrayDataProvider($cvisita->getVisitaList($visitaQueryForm), array('keyField' => 'id_visita', 'id' => 'lstVisitasResult', 'sort'=>array('attributes'=>array('fe_ingreso', 'no_full_invitado', 'no_entidad_representada', 'no_lugar_reunion', 'no_full_colaborador', 'no_motivo_visita', 'no_full_documento',),),));
			}
			else {
				$lstVisitasResult =  new CArrayDataProvider(array(), array('keyField' => 'id_visita', 'id' => 'lstVisitasResult', 'sort'=>array('attributes'=>array('fe_ingreso', 'no_full_invitado', 'no_entidad_representada', 'no_lugar_reunion', 'no_full_colaborador', 'no_motivo_visita', 'no_full_documento',),),));
			}

			$this->render('lstVisitas', array('visitaQueryForm' => $visitaQueryForm, 'lstVisitasResult' => $lstVisitasResult));
		}
		else {
			$visitaQueryForm->inActivo = 7;//solo activos
			$visitaQueryForm->idSede = Yii::app()->user->id_sede;
			//$visitaQueryForm->setAttributes($_POST['VisitaQueryForm']);
			//error_log('aca default!!');
			$lstVisitasResult =  new CArrayDataProvider($cvisita->getVisitaList($visitaQueryForm), array('keyField' => 'id_visita', 'id' => 'lstVisitasResult', 'sort'=>array('attributes'=>array('fe_ingreso', 'no_full_invitado', 'no_entidad_representada', 'no_lugar_reunion', 'no_full_colaborador', 'no_motivo_visita', 'no_full_documento',),),));
			// renders the view file 'protected/views/site/index.php'
			// using the default layout 'protected/views/layouts/main.php'
			$this->render('lstVisitas', array('visitaQueryForm' => $visitaQueryForm, 'lstVisitasResult' => $lstVisitasResult));
		}
	}

	public function actionUpdateItemSalidaVisita() {
		if (isset($_POST['VisitaForm'])) {
			//ajax
			//formulario envio submit, se debde de procesarlo...
			$visitaForm = new VisitaForm;
			$visitaForm->attributes = $_POST['VisitaForm'];
			$cvisita = new CVisita();
			$objVisita = $cvisita->getVisita(array('id_visita' => $visitaForm->idVisita));
			$visitaIsModifiable = false;
			//error_log("fe_salida::" . print_r($objVisita->fe_salida, true));
			if ($objVisita->fe_salida != '') {
				//ya seteado, modificar solo cuando estamos en la misma fecha
				$arrFechaHora = explode(' ', $objVisita->fe_salida);//Y-m-d H:i:s   datetime
				if (date('Y-m-d') === $arrFechaHora[0]) {
					$visitaIsModifiable = true;
				}
				else {
					$visitaIsModifiable = false;
				}
			}
			else {
				$visitaIsModifiable = true;
			}
			$fechaIngresoSalidaValidated = false;
			if ($visitaIsModifiable) {
				$visitaFormValidated = $visitaForm->validate();
				if ($visitaFormValidated) {
					//$objVisita->fe_ingreso;//Y-m-d H:i:s
					//$visitaForm->feSalida//d/m/Y
					//$visitaForm->hoSalida//H:i solo hora y minutos
					
					$arrFeSalida = explode('/', $visitaForm->feSalida);
					$intTimeIngreso = strtotime($objVisita->fe_ingreso);
					$intTimeSalida = strtotime($arrFeSalida[2] . '-' . $arrFeSalida[1] . '-' . $arrFeSalida[0] . ' ' . $visitaForm->hoSalida . ':00');
					$intTimeFinalDiaHoy = mktime(23, 59, 59, date("n"), date("j"),  date("Y"));
					//no podra asignar una fecha de salida anterior a su fecha de ingreso, ni podra asignar una fecha de salida para el dia siguiente 
					if (!($intTimeSalida > $intTimeIngreso && $intTimeSalida <= $intTimeFinalDiaHoy)) {
						$fechaIngresoSalidaValidated = false;
					}
					else {
						$fechaIngresoSalidaValidated = true;
					}
				}
			}
			
			if (!$visitaFormValidated || !$fechaIngresoSalidaValidated || !$visitaIsModifiable) {
				header("Status: 500 Internal Server Error", true, 500);
				if (!$visitaIsModifiable) {
					echo json_encode(array("message" => "El registro no es modificable dado que ya tiene fecha y hora de salida asignada. La asignación o modificación de la hora de salida solo se puede realizar un tiempo despues del día de ingreso. Verifique."));
				}
				else if (!$visitaFormValidated) {
					$validationResult = array();
					foreach($visitaForm->getErrors() as $attribute => $errors) {
						$validationResult[CHtml::activeId($visitaForm, $attribute)] = $errors;
					}
					$jsonResult = json_encode(array("message" => "Existen errores de validaciones. Verifique.", "validationResult" => $validationResult));
					echo $jsonResult;
				}
				else if (!$fechaIngresoSalidaValidated) {
					$validationResult = array();
					$validationResult[CHtml::activeId($visitaForm, 'feSalida')] = array('La fecha y hora de salida debe ser mayor que la fecha y hora de ingreso pero menor que la fecha del dia siguiente. Verifique.');
					$jsonResult = json_encode(array("message" => "Existen errores de validaciones. Verifique.", "validationResult" => $validationResult));
					echo $jsonResult;
				}
				Yii::app()->end();//exit
			}
			else {
				//sin errores
				try {
					$arrFeSalida = explode('/', $visitaForm->feSalida);
					$objVisita->fe_salida = $arrFeSalida[2] . '-' . $arrFeSalida[1] . '-' . $arrFeSalida[0] . ' ' . $visitaForm->hoSalida . ':00';//Y-m-d H:i completar segundos
					$objVisita->no_usuario_modificacion = Yii::app()->user->no_usuario;
					$arrParams = array('arrVisitas' => array($objVisita));
					$cvisita->updateVisitas($arrParams);
					echo json_encode(array("message" => "Actualizado exitosamente."));
				}
				catch (Exception $e) {
					error_log("exception::" . print_r($e, true));
					header("Status: 500 Internal Server Error", true, 500);
					echo json_encode(array("message" => "Hubo un error al actualizar. Verifique."));
				}
				Yii::app()->end();//exit
			}
		}
		else if (isset($_REQUEST['id_visita']) && $_REQUEST['id_visita'] != '') {
			//mostrar formulario
			$cvisita = new CVisita();
			$objVisita = $cvisita->getVisita(array('id_visita' => $_REQUEST['id_visita']));
			
			$visitaForm = new VisitaForm;
			$visitaForm->idVisita = $objVisita->id_visita;
			$visitaForm->noColaborador = $objVisita->no_colaborador . ' ' . $objVisita->ap_paterno_colaborador . ' ' . $objVisita->ap_materno_colaborador;
			$visitaForm->noInvitado = $objVisita->objInvitado->no_invitado . ' ' . $objVisita->objInvitado->ap_paterno_invitado . ' ' . $objVisita->objInvitado->ap_materno_invitado;
			
			$visitaForm->feHoIngreso = date('d/m/Y H:i:s', strtotime($objVisita->fe_ingreso));//parsea formato iso de fecha yyyy-mm-dd hh:mm:ss
			
			//deberia de modificarlo si,
			//la fecha de salida está vacio
			//la fecha de salida _no_ está vacio y la fecha actual coincide con la fecha de ingreso...
			if ($objVisita->fe_salida != '') {
				$visitaForm->isSuggested = false;
				$arrFechaHora = explode(' ', $objVisita->fe_salida);//Y-m-d H:i:s   datetime
				$arrFecha = explode('-', $arrFechaHora[0]);
				$visitaForm->feSalida = $arrFecha[2] . '/' . $arrFecha[1] . '/' . $arrFecha[0];//si tiene fecha hora de salida ya seteada, puede modificarlo todavia?...  d/m/Y
				$visitaForm->hoSalida = $arrFechaHora[1];//si tiene fecha hora de salida ya seteada, puede modificarlo todavia?...
				
				if (date('Y-m-d') === $arrFechaHora[0]) {
					$visitaForm->isModifiable = true;
				}
				else {
					$visitaForm->isModifiable = false;
				}
			}
			else {
				$visitaForm->isModifiable = true;
				$visitaForm->isSuggested = true;
			}

			//sugerir fecha y hora de salida
			if ($visitaForm->isSuggested) {
				$visitaForm->feSalida = date('d/m/Y');
				$visitaForm->hoSalida = date('H:i');
			}
			
			$this->render('editVisita', array('visitaForm' => $visitaForm));
		}
		else if (isset($_POST['chk_id_visita']) && isset($_POST['ho_salida'])) {
			$arrFeSalida = explode('/', date('d/m/Y'));
			$hoSalida = $_POST['ho_salida'];
			$chkIdVisita = $_POST['chk_id_visita'];
			$cvisita = new CVisita();
			$arrMessageErrors = array();
			foreach ($chkIdVisita as $idVisita) {
				$objVisita = $cvisita->getVisita(array('id_visita' => $idVisita));
				$visitaIsModifiable = false;
				//error_log("objVisita->fe_salida" . $objVisita->fe_salida);
				if ($objVisita->fe_salida != '') {
					//ya seteado, modificar solo cuando estamos en la misma fecha
					//error_log("objVisita->fe_salida lleno");
					$arrFechaHora = explode(' ', $objVisita->fe_salida);//Y-m-d H:i:s   datetime
					if (date('Y-m-d') === $arrFechaHora[0]) {
						$visitaIsModifiable = true;
					}
					else {
						$visitaIsModifiable = false;
					}
				}
				else {
				    //error_log("objVisita->fe_salida vacio");
					//solo ingresar horas de salida masivas si el ingreso ha sido la fecha de hoy
					$arrFechaHora = explode(' ', $objVisita->fe_ingreso);//Y-m-d H:i:s   datetime
					//error_log("objVisita->fe_ingreso::" . $objVisita->fe_ingreso);
					//error_log("var_export(objVisita->fe_ingreso)::" . var_export($objVisita->fe_ingreso, true));
					if (date('Y-m-d') === $arrFechaHora[0]) {
						$visitaIsModifiable = true;
					}
					else {
						$visitaIsModifiable = false;
					}
				}
				$fechaIngresoSalidaValidated = false;
				if ($visitaIsModifiable) {
					$intTimeIngreso = strtotime($objVisita->fe_ingreso);
					$intTimeSalida = strtotime($arrFeSalida[2] . '-' . $arrFeSalida[1] . '-' . $arrFeSalida[0] . ' ' . $hoSalida . ':00');
					$intTimeFinalDiaHoy = mktime(23, 59, 59, date("n"), date("j"),  date("Y"));
					if (!($intTimeSalida > $intTimeIngreso && $intTimeSalida <= $intTimeFinalDiaHoy)) {
						$fechaIngresoSalidaValidated = false;
					}
					else {
						$fechaIngresoSalidaValidated = true;
					}
				
				}
				
				if (!$fechaIngresoSalidaValidated || !$visitaIsModifiable) {
					if (!$visitaIsModifiable) {
						$arrMessageErrors[] = "El registro " . $objVisita->id_visita . " de numero de documento " . $objVisita->objInvitado->nu_documento . " no es modificable dado que ya tiene fecha y hora de salida asignada o tiene una fecha de ingreso de dia anterior. La asignación o modificación de la hora de salida solo se puede realizar en la día del ingreso. Verifique.";
					}
					else if (!$fechaIngresoSalidaValidated) {
						$arrMessageErrors[] = "El registro " . $objVisita->id_visita . " de numero de documento " . $objVisita->objInvitado->nu_documento . " su fecha y hora de salida debe ser mayor que la fecha y hora de ingreso pero menor que la fecha del día siguiente. Verifique.";
					}
				}
			}
			
			if (count($arrMessageErrors) == 0) {
				//sin errores
				try {
					$arrParams = array('arrVisitas' => array());
					foreach ($chkIdVisita as $idVisita) {
						$objVisita = $cvisita->getVisita(array('id_visita' => $idVisita));
						$objVisita->fe_salida = $arrFeSalida[2] . '-' . $arrFeSalida[1] . '-' . $arrFeSalida[0] . ' ' . $hoSalida . ':00';//Y-m-d H:i completar segundos
						$objVisita->no_usuario_modificacion = Yii::app()->user->no_usuario;
						$arrParams['arrVisitas'][] = $objVisita;
					}
					$cvisita->updateVisitas($arrParams);
					echo json_encode(array("message" => "Actualizado exitosamente."));
				}
				catch (Exception $e) {
					error_log("exception::" . print_r($e, true));
					header("Status: 500 Internal Server Error", true, 500);
					echo json_encode(array("message" => "Hubo un error al asignar la hora de salida. Verifique."));
				}
			}
			else {
				header("Status: 500 Internal Server Error", true, 500);
				echo json_encode(array("message" => implode("\n", $arrMessageErrors)));
			}
			Yii::app()->end();//exit
		}
	}

	public function actionDeleteItemVisitaResultGrid() {
		if (isset($_REQUEST['id_visita']) && $_REQUEST['id_visita'] != '') {
			$cvisita = new CVisita();
			try {
				$arrParams = array('arrIdVisitas' => array($_REQUEST['id_visita']));
				$objVisita = $cvisita->getVisita(array('id_visita' => $_REQUEST['id_visita']));
				$objVisita->in_activo = 8;//desactivado, y no se visualizará en el listado
				$objVisita->no_usuario_modificacion = Yii::app()->user->no_usuario;
				
				$arrParams = array('arrVisitas' => array($objVisita));
				$cvisita->updateVisitas($arrParams);
				//$cvisita->deleteVisitas($arrParams);
				echo json_encode(array("message" => "Borrado exitoso"));
			}
			catch (Exception $e) {
				error_log("exception::" . print_r($e, true));
				header("Status: 500 Internal Server Error", true, 500);
				echo json_encode(array("message" => "Hubo un error al procesar el borrado. Verifique."));
			}
		}
	}

	protected function echoLstVisitasResultGrid($lstVisitasResult) {
		$this->widget('zii.widgets.grid.CGridView', array(
				'id'=>'lst-visitas-result-grid',
				'dataProvider' => $lstVisitasResult,
				'ajaxUpdate' => false,
				'ajaxUrl' => '',
				/*'url' => '',*/
				'columns' => array(
						array('name' => 'id_visita', 'class' => 'CCheckBoxColumn', 'selectableRows' => 2, 'id' => 'chk_id_visita'),
						array('name' => 'fe_ingreso', 'type' => 'text', 'header' => 'FECHA'),
						'no_full_invitado:text:VISITANTE',
						'no_full_documento:text:DOCUMENTO',
						'no_entidad_representada:text:ENTIDAD',
						'no_motivo_visita:text:MOTIVO',
						'no_full_colaborador:text:EMPLEADO PÚBLICO',
						'no_full_lugar_reunion:text:LUGAR',
						'ho_ingreso:text:HORA ING.',
						'ho_salida:text:HORA SAL.',
						array(
								'class' => 'CButtonColumn',
								'template' => '{update}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{delete}',
								'buttons' => array(
										'update' => array(
												'click'	=>	"function() {
													$('#ifrSalidaVisita').attr('src', '');
													$('#ifrSalidaVisita').attr('src', $(this).attr('href'));
													$('#updateSalidaVisita').dialog('open');
													//alert('click');
													return false;
												}",
												'url'   => 'Yii::app()->controller->createUrl("/recepcion/visitaDetalle/updateItemSalidaVisita", array("id_visita" => $data["id_visita"]))',
												'options' => array('title' => 'Registrar Salida'),
										),
										'delete' => array(
												'click'	=>	"function() {
													if (!confirm('¿Está seguro de borrar este elemento?')) {
														return false;
													}
													$.ajax({
													        url: $(this).attr('href'),
													        async: false,
													        error: function(jqXHR, textStatus, errorThrown) {
																if (jqXHR.responseText.indexOf('{') == 0) {
																	var dataJson = jQuery.parseJSON(jqXHR.responseText);
																	alert(dataJson.message);
																}
													        },
													        success: function(data, textStatus, jqXHR) {
																var dataJson = jQuery.parseJSON(data);
																alert(dataJson.message);
																$('#btBuscarVisitas').click();
													        },
													        type: 'POST'
													});
													return false;
												}",//al hacer click llama a esta funcion
												'url'   => 'Yii::app()->controller->createUrl("/recepcion/visitaDetalle/deleteItemVisitaResultGrid", array("id_visita" => $data["id_visita"]))',//esta queda como dato, desactivado para llamarse
												//'update' => '#lst-visitas-result-grid',//desactivado
										),
								),
								/*'afterDelete' => 'function(link, success, data) {
									if (success) {
										//data es texto, hay q parsearlo a json
										var dataJson = jQuery.parseJSON(data);
										alert(dataJson.message);
										//alert(link);
										//TODO redireccionar
										$("#btBuscarVisitas").click();
									}
									else {
										//on error
										if (data.responseText.indexOf(\'{\') == 0) {
											var dataJson = jQuery.parseJSON(data.responseText);
											alert(dataJson.message);
										}
									}
									return false;//false para q no siga el flujo en js...
								}',*/
						),
				),
		));
	}
}