<?php

class VisitaAdderController extends Controller
{
	public $layout='//layouts/standard';

	/**
	 * @return array action filters
	 */
	public function filters() {
		return array(
				'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
				/*array('allow',  // allow all users to perform 'index' and 'view' actions
						'actions' => array('view'),
						'users' => array('*'),
				),*/
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('index', 'updateVisitaInvitadoGrid', 'ubicarInvitado', 'deleteItemVisitaInvitadoGrid', 'searchAutoComplete','updateVisitaVisitante','saveVisitaVisitante'/*, 'logicalDelete'*/),
						'users' => array('@'),
						'roles' => array('RECEPCION'),
				),
				/*array('allow', // allow admin user to perform 'admin' and 'delete' actions
						'actions' => array('admin'),
						'users' => array('admin'),
				),*/
				array('deny',  // deny all users
						'users' => array('*'),
				),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex() {

		$cvisita = new CVisita();
		if(isset($_POST['ajax']) && $_POST['ajax'] === 'visita-query-form') {
			//if(Yii::app()->request->isAjaxRequest){
			error_log('aca ajax!!');
		}
		else if (isset($_POST['VisitaInvitadoForm'])) {//ajax...
			//error_log('aca post!!');
			//agregar un nuevo visitante a la session...
			$visitaInvitadoForm = new VisitaInvitadoForm;
			$visitaInvitadoForm->attributes = $_POST['VisitaInvitadoForm'];
			$visitaInvitadoForm->validate();
			$validationResult = array();
			foreach($visitaInvitadoForm->getErrors() as $visitaInvitadoFormAttribute => $visitaInvitadoFormErrors) {
				$validationResult[CHtml::activeId($visitaInvitadoForm, $visitaInvitadoFormAttribute)] = $visitaInvitadoFormErrors;
			}
			//$validationResult = CActiveForm::validate($visitaInvitadoForm);
			//error_log("count::" . count($visitaInvitadoForm->getErrors()));
			if (count($visitaInvitadoForm->getErrors()) > 0) {
				//setear a error..
				//error_log("setear error");
				header("Status: 500 Internal Server Error", true, 500);
				$jsonResult = array('message' => 'Hubo errores de validaciones. Verifique.', 'validationResult' => $validationResult);
				echo json_encode($jsonResult);
			}
			else {
				$cdominio = new CDominio();
				$lstTiDocs = $cdominio->getDominioDetalleList(array('id_detalle_dominio' => $visitaInvitadoForm->tiDocumento));
				if (count($lstTiDocs) > 0) {
					$visitaInvitadoForm->noTiDocumento = $lstTiDocs[0]->no_detalle_dominio;
				}
				$visitasForm = new VisitasForm();
				if (isset($_SESSION['SessVisitasForm'])) {
					$visitasForm = $_SESSION['SessVisitasForm'];
				}
				else {
					$_SESSION['SessVisitasForm'] = $visitasForm;
				}
				$lstTmpVisitaInvitados =& $visitasForm->lstVisitaInvitados;//array de clases VisitaInvitadoForm, joder... no que era orientado a objetos? por que necesito la referencia &
				//Verificar si es repetido con el listado!
				$blNoRepetidos = true;
				foreach ($lstTmpVisitaInvitados as $visitaInvitado) {
					if ($visitaInvitado->tiDocumento == $visitaInvitadoForm->tiDocumento &&
							$visitaInvitado->nuDocumento == $visitaInvitadoForm->nuDocumento) {
						$blNoRepetidos = false;
					}
				}
				if (!$blNoRepetidos) {
					$jsonResult = array('message' => 'El visitante de documento ' . $visitaInvitadoForm->noTiDocumento . ' y de numero de documento ' . $visitaInvitadoForm->nuDocumento  . ' ya ha sido agregado al listado. Verifique.');
					header("Status: 500 Internal Server Error", true, 500);
					echo json_encode($jsonResult);
				}
				else {
					//ahora si no hay errores!!
					$lstTmpVisitaInvitados[] = $visitaInvitadoForm;
				}

				//error_log("anexado en un listado de una variable de la sesion::count::" . count($visitasForm->lstVisitaInvitados));
				//error_log("anexado en un listado de una variable de la sesion::count::" . count($lstTmpVisitaInvitados));
			}
			Yii::app()->end();
		}
		else if (isset($_POST['VisitasForm'])) {//ajax
			try {
				//error_log('aca post!!');
				//grabar todo lo que se hizo en session...
				if (!isset($_SESSION['SessVisitasForm'])) {
					$visitasForm = new VisitasForm();
					$_SESSION['SessVisitasForm'] = $visitasForm;
				}
				else {
					$visitasForm = $_SESSION['SessVisitasForm'];
				}
				//$visitasForm->clearErrors();
				//$visitasForm->attributes = $_POST['VisitasForm'];
				
				//se hizo esto, por problemas de cargar las clases desde la session, algunas propiedades se pierden
				$visitasFormTmp = new VisitasForm();
				$visitasFormTmp->attributes = $_POST['VisitasForm'];
				$visitasFormTmp->lstVisitaInvitados = $visitasForm->lstVisitaInvitados;
				$visitasForm = $visitasFormTmp;
					
				//$jsonResult = CActiveForm::validate($visitasForm);
				//error_log("count::" . count($visitaInvitadoForm->getErrors()));
				$visitasFormValidated = $visitasForm->validate();
			}
			catch (Exception $e) {
				error_log("exception::" . print_r($e, true));
				$visitasFormValidated = false;
			}
			
			if (!$visitasFormValidated) {
				$validationResult = array();
				foreach($visitasForm->getErrors() as $attribute => $errors) {
					$validationResult[CHtml::activeId($visitasForm, $attribute)] = $errors;
				}
				$jsonResult = json_encode(array("message" => "Existen errores de validaciones. Verifique.", "validationResult" => $validationResult));
				//setear a error..
				//error_log("Errores de validacion::" . print_r($validationResult, true));
				header("Status: 500 Internal Server Error", true, 500);
				echo $jsonResult;
			}
			else {
				//no hay errores!!
				try {
					$visitasForm->idSede = Yii::app()->user->id_sede;
					$visitasForm->noUsuarioResgistro = Yii::app()->user->no_usuario;
					//error_log("antes de grabar::");
					$cvisita->saveVisita($visitasForm);
					//error_log("despues de grabar::");
					unset($_SESSION['SessVisitasForm']);
				}
				catch (Exception $e) {
					error_log("exception::" . print_r($e, true));
					error_log("exception::cantidad de invitados:" . count($visitasForm->lstVisitaInvitados));
					$jsonResult = json_encode(array("message" => "Hubo un error al grabar los datos. Tal vez haya ingresado este invitado anteriormente pero con otro número de DNI. Verifique."));//, "executionResult" => $e->getMessage()
					header("Status: 500 Internal Server Error", true, 500);
					echo $jsonResult;
				}
			}
			Yii::app()->end();
		}
		else {
			unset($_SESSION['SessVisitasForm']);//limpiar la session, por cuanto es nueva carga...
			$clugarReunion = new CLugarReunion();
			$ccolaborador = new CColaborador();
			$cdominio = new CDominio();
			$visitasForm = new VisitasForm();
			$visitaInvitadoForm = new VisitaInvitadoForm();
			$visitaInvitadoForm->tiDocumento = 1;
			$arrTiDocumentos = CHtml::listData($cdominio->getDominioDetalleList(array('id_dominio' => 1)), 'id_detalle_dominio', 'no_detalle_dominio');
			$arrTiMotivos = CHtml::listData($cdominio->getDominioDetalleList(array('id_dominio' => 3)), 'no_detalle_dominio', 'no_detalle_dominio');
			//agregar un option con la etiqueta "[SELECCIONE]"
			//error_log("lst?::" . print_r($arrTiDocumentos, true));
			$visitaInvitadoForm->lstTiDocumentos = $arrTiDocumentos;
			$visitasForm->lstTipoMotivos = array('' => '[SELECCIONE]') + $arrTiMotivos;
			//$lstTmpVisitaInvitados = $visitasForm->lstVisitaInvitados;//array de clases VisitaInvitadoForm
			
			$arrColaboradores = array();
			$arrColaboradores[] = array('id_colaborador' => '', 'no_completo' => '[SELECCIONE]',);
			$lstTmpColaboradores = $ccolaborador->getColaboradoresList(array('id_sede' => Yii::app()->user->id_sede));
			foreach ($lstTmpColaboradores as $objColaborador) {
				$arrColaboradores[] = array('id_colaborador' => $objColaborador->id_colaborador, 'no_completo' => $objColaborador->no_colaborador . ' ' . $objColaborador->ap_paterno_colaborador,);
			}
			$arrColaboradores = CHtml::listData($arrColaboradores, 'id_colaborador', 'no_completo');
			$visitasForm->lstColaboradores = $arrColaboradores;
			
			/*$arrColaboradores = array();
			$arrColaboradores[] = array('id_lugar_reunion' => '', 'no_completo' => '[SELECCIONE]',);*/
			$lstTmpLugarReunion = $clugarReunion->getLugarReunionList(array('id_sede' => Yii::app()->user->id_sede));
			$arrLugarReuniones = CHtml::listData($lstTmpLugarReunion, 'no_lugar_reunion', 'no_lugar_reunion');
			$visitasForm->lstLugarReuniones = array('' => '[SELECCIONE]') + $arrLugarReuniones;
			//$arrVisitaInvitados = array();
			/*foreach ($lstTmpVisitaInvitados as $visitaInvitado) {
				$arrVisitaInvitados[] = array(
											'tiDocumento' => $visitaInvitado->tiDocumento,
											'noTiDocumento' => $visitaInvitado->noTiDocumento,
											'nuDocumento' => $visitaInvitado->nuDocumento,
											'noInstitucion' => $visitaInvitado->noInstitucion,
											'noInvitado' => $visitaInvitado->noInvitado,
											'apPaternoInvitado' => $visitaInvitado->apPaternoInvitado,
											'apMaternoInvitado' => $visitaInvitado->apMaternoInvitado,
											'coPase' => $visitaInvitado->coPase);
			}*/
			
			$lstVisitaInvitados =  new CArrayDataProvider(array(), array('keyField' => false, 'id' => 'lstVisitaInvitados'));
			//error_log('aca default!!');
			// renders the view file 'protected/views/site/index.php'
			// using the default layout 'protected/views/layouts/main.php'
			$this->render('addVisitas', array('visitaInvitadoForm' => $visitaInvitadoForm, 'lstVisitaInvitados' => $lstVisitaInvitados, 'visitasForm' => $visitasForm));
		}
	}
	
	public function actionUpdateVisitaInvitadoGrid() {
		//error_log('ajax!::' . print_r($_REQUEST, true));
		$visitasForm = new VisitasForm();
		if (isset($_SESSION['SessVisitasForm'])) {
			$visitasForm = $_SESSION['SessVisitasForm'];
		}
		else {
			$_SESSION['SessVisitasForm'] = $visitasForm;
		}
		
		$lstTmpVisitaInvitados = $visitasForm->lstVisitaInvitados;//array de clases VisitaInvitadoForm
		//error_log("retiendo el listado de una variable de la sesion::count::" . count($visitasForm->lstVisitaInvitados));
		$arrVisitaInvitados = array();
		foreach ($lstTmpVisitaInvitados as $visitaInvitado) {
			$arrVisitaInvitados[] = array(
					'tiDocumento' => $visitaInvitado->tiDocumento,
					'noTiDocumento' => $visitaInvitado->noTiDocumento,
					'nuDocumento' => $visitaInvitado->nuDocumento,
					'noInstitucion' => $visitaInvitado->noInstitucion,
					'noInvitado' => $visitaInvitado->noInvitado,
					'apPaternoInvitado' => $visitaInvitado->apPaternoInvitado,
					'apMaternoInvitado' => $visitaInvitado->apMaternoInvitado,
					'coPase' => $visitaInvitado->coPase);
		}
			
		$lstVisitaInvitados =  new CArrayDataProvider($arrVisitaInvitados, array('keyField' => false, 'id' => 'lstVisitaInvitados'));
		
		$this->echoLstVisitaInvitadosGrid($lstVisitaInvitados);
	}
	
	/**
	 * Siendo protected, es visible como metodo en su respectivo view! 
	 **/
	protected function echoLstVisitaInvitadosGrid($lstVisitaInvitados) {
		/*echo "<b>aca estará el grid?</b>";*/
		$this->widget('zii.widgets.grid.CGridView', array(
				'id'	=>	'lst-visita-invitados-grid',
				'dataProvider' => $lstVisitaInvitados,
				'ajaxUrl' => Yii::app()->createUrl('/recepcion/visitaAdder/updateVisitaInvitadoGrid'),
				/*'cssFile' => Yii::app()->baseUrl . '/css/gridViewStyle/gridView.css',*/
				/*'ajaxUpdate'	=>	true,*/
				'columns' => array(
						'noTiDocumento:text:DOC.',
						'nuDocumento:text:NRO. DOCUMENTO',
						'apPaternoInvitado:text:APELLIDO PATERNO',
						'apMaternoInvitado:text:APELLIDO MATERNO',
						'noInvitado:text:NOMBRES',
						'coPase:text:PASE',
						array(
								'class' => 'CButtonColumn',
								'template' => '{update}',
								'buttons' => array(
										'update' => array(
												'click'	=>	"function() {
													$('#ifrDialogUpdateVistante').attr('src', '');
													$('#ifrDialogUpdateVistante').attr('src', $(this).attr('href'));
													$('#dlgUpdateVistante').dialog('open');
													//alert('click');
													return false;
												}",
												'url'   => 'Yii::app()->controller->createUrl("updateVisitaVisitante", array("tiDocumento" => $data["tiDocumento"], "nuDocumento" => $data["nuDocumento"], "noInvitado" => $data["noInvitado"]))',
												'options' => array('title' => 'Actualizar Visitante'),
										),
								),
						),
						array(
								'class' => 'CButtonColumn',
								'template' => '{delete}',
								'buttons' => array(
										'delete' => array(
												/*'click'	=>	"function() {alert('click'); return false;}",*///no necesario
												'url'   => 'Yii::app()->controller->createUrl("deleteItemVisitaInvitadoGrid", array("tiDocumento" => $data["tiDocumento"], "nuDocumento" => $data["nuDocumento"], "noInvitado" => $data["noInvitado"]))',//al hacer click llama a esta url
												'update' => '#lst-visita-invitados-grid',//con esto va a actualizar una region del html, si es q el action devuelve algo, en este caso se espera que devuelva el html de todo el grid actualizado
										),
								),
						),
				),
		));
	}
	
	public function actionDeleteItemVisitaInvitadoGrid() {
		if (isset($_SESSION['SessVisitasForm']) && 
				isset($_REQUEST['tiDocumento']) && $_REQUEST['tiDocumento'] != '' &&
				isset($_REQUEST['nuDocumento']) && $_REQUEST['nuDocumento'] != '' &&
				isset($_REQUEST['noInvitado']) && $_REQUEST['noInvitado'] != '') {
			$visitasForm = $_SESSION['SessVisitasForm'];
			$lstTmpVisitaInvitados =& $visitasForm->lstVisitaInvitados;//array de clases VisitaInvitadoForm
			for ($i = 0; $i < count($lstTmpVisitaInvitados); $i++) {
				$visitaInvitado = $lstTmpVisitaInvitados[$i];
				if ($visitaInvitado->tiDocumento == $_REQUEST['tiDocumento'] &&
						$visitaInvitado->nuDocumento == $_REQUEST['nuDocumento'] &&
						$visitaInvitado->noInvitado == $_REQUEST['noInvitado']) {
					unset($lstTmpVisitaInvitados[$i]);
				}
			}
		}
		
		$this->actionUpdateVisitaInvitadoGrid();//para q actualice el grid, despues del borrado
	}
	
	public function actionUpdateVisitaVisitante()
	{
		$visitaInvitadoForm = new VisitaInvitadoForm();		
				
		if (isset($_SESSION['SessVisitasForm']) && 
				isset($_REQUEST['tiDocumento']) && $_REQUEST['tiDocumento'] != '' &&
				isset($_REQUEST['nuDocumento']) && $_REQUEST['nuDocumento'] != '' &&
				isset($_REQUEST['noInvitado']) && $_REQUEST['noInvitado'] != '') {
			$visitasForm = $_SESSION['SessVisitasForm'];
			$lstTmpVisitaInvitados =& $visitasForm->lstVisitaInvitados;//array de clases VisitaInvitadoForm
			for ($i = 0; $i < count($lstTmpVisitaInvitados); $i++) {
				$visitaInvitado = $lstTmpVisitaInvitados[$i];
				if ($visitaInvitado->tiDocumento == $_REQUEST['tiDocumento'] &&
						$visitaInvitado->nuDocumento == $_REQUEST['nuDocumento'] &&
						$visitaInvitado->noInvitado == $_REQUEST['noInvitado']) {
					$visitaInvitadoForm->apPaternoInvitado = $visitaInvitado->apPaternoInvitado;
					$visitaInvitadoForm->apMaternoInvitado = $visitaInvitado->apMaternoInvitado;
					$visitaInvitadoForm->noInvitado = $visitaInvitado->noInvitado;
					$visitaInvitadoForm->tiDocumento = $visitaInvitado->tiDocumento;
					$visitaInvitadoForm->nuDocumento = $visitaInvitado->nuDocumento;					
					
					break;
				}
			}
		}
		
		$this->render('editVisitaVisitante', array('visitaInvitadoForm' => $visitaInvitadoForm));
	}
	
	public function actionSaveVisitaVisitante()			
	{			
		if (isset($_SESSION['SessVisitasForm']) && isset($_POST['VisitaInvitadoForm'])) {
			$formInfo = $_POST['VisitaInvitadoForm'];
			$visitasForm = $_SESSION['SessVisitasForm'];
			$lstTmpVisitaInvitados =& $visitasForm->lstVisitaInvitados;//array de clases VisitaInvitadoForm
			for ($i = 0; $i < count($lstTmpVisitaInvitados); $i++) {
				$visitaInvitado = $lstTmpVisitaInvitados[$i];
				if ($visitaInvitado->tiDocumento == $formInfo['tiDocumento'] &&
						$visitaInvitado->nuDocumento == $formInfo['nuDocumento']) {
					
					$visitaInvitado->apPaternoInvitado = $formInfo['apPaternoInvitado'];
					$visitaInvitado->apMaternoInvitado = $formInfo['apMaternoInvitado'];
					$visitaInvitado->noInvitado = $formInfo['noInvitado'];
					
					$_SESSION['SessVisitasForm'] = $visitasForm;				
					
					break;
				}
			}
		}
	
		echo json_encode("Datos actualizados");
		Yii::app()->end();
	}
	
	//chora nme liga
	public function actionUbicarInvitado() {
		$cinvitado = new CInvitado();
		$arrParams = array();
		$arrInvitado = array();
		if (isset($_REQUEST['ti_documento']) && $_REQUEST['ti_documento'] != '' &&
				isset($_REQUEST['nu_documento']) && $_REQUEST['nu_documento'] != '') {
			$arrParams['ti_documento'] = $_REQUEST['ti_documento'];
			$arrParams['nu_documento'] = $_REQUEST['nu_documento'];
			$arrInvitado = $cinvitado->getInvitadosList($arrParams);
		}
		else if (isset($_REQUEST['no_invitado']) && $_REQUEST['no_invitado'] != '' &&
				isset($_REQUEST['ap_paterno_invitado']) && $_REQUEST['ap_paterno_invitado'] != '') {
			$arrParams['no_invitado'] = $_REQUEST['no_invitado'];
			$arrParams['ap_paterno_invitado'] = $_REQUEST['ap_paterno_invitado'];
			if (isset($_REQUEST['ap_materno_invitado']) && $_REQUEST['ap_materno_invitado'] != '') {
				$arrParams['ap_materno_invitado'] = $_REQUEST['ap_materno_invitado'];
			}
			$arrInvitado = $cinvitado->getInvitadosList($arrParams);
		}
		if (count($arrInvitado) == 1) {
			$invitado = $arrInvitado[0];
			$cdominio = new CDominio();
			$lstDominioDetalle = $cdominio->getDominioDetalleList(array('id_detalle_dominio' => $invitado->ti_documento));
			$noTiDocumento = '';
			if (count($lstDominioDetalle) == 1) {
				$noTiDocumento = $lstDominioDetalle[0]->no_detalle_dominio;
			}
			echo json_encode(array('id_invitado' => $invitado->id_invitado,'no_invitado' => $invitado->no_invitado, 'ap_paterno_invitado' => $invitado->ap_paterno_invitado, 'ap_materno_invitado' => $invitado->ap_materno_invitado, 'no_entidad_representada' => $invitado->no_entidad_representada, 'nu_documento' => $invitado->nu_documento, 'ti_documento' => $invitado->ti_documento, 'no_ti_documento' => $noTiDocumento));
		}
	}
	
	public function actionSearchAutoComplete() {
		$arrResult = array();
		if (isset($_GET['term']) && $_GET['term'] != '') {
			$ccolaborador = new CColaborador();
			$cdominio = new CDominio();
			$arrDniExcepciones = array();
			$lstDominioDetalle = $cdominio->getDominioDetalleList(array('id_dominio' => 5));
			foreach ($lstDominioDetalle as $objDetalleDominio) {
				$arrDniExcepciones[] = $objDetalleDominio->va_columna_01;
			}
			
			$arrParams = array();
			$arrParams['searchNombreCompleto'] = $_GET['term'];
			$arrParams['id_sede'] = Yii::app()->user->id_sede;
			if (count($arrDniExcepciones) > 0) {
				$arrParams['dni_excepciones'] = $arrDniExcepciones;
			}
			$arrAnfitriones = $ccolaborador->getColaboradoresList($arrParams);
			foreach ($arrAnfitriones as $anfitrion) {
				$oficina = "";
				if($anfitrion->no_oficina!=null or $anfitrion->no_oficina!="")
					$oficina = " (". $anfitrion->no_oficina. ")";
						
				$arrResult[] = array(
						'value' => $anfitrion->no_colaborador . ' ' . $anfitrion->ap_paterno_colaborador . ' ' . $anfitrion->ap_materno_colaborador,
						'label' => $anfitrion->no_colaborador . ' ' . $anfitrion->ap_paterno_colaborador . ' ' . $anfitrion->ap_materno_colaborador . $oficina,
						'id' => $anfitrion->id_colaborador,
				);
			}
		}
		echo json_encode($arrResult);
		Yii::app()->end();
	}
}