<?php


class InstitutoMiniController extends Controller {
	
	public $layout='//layouts/standard';
	
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
				'accessControl', // perform access control for CRUD operations
		);
	}
	
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
				/*array('allow',  // allow all users to perform 'index' and 'view' actions
						'actions' => array('view'),
						'users' => array('*'),
				),*/
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('index', 'update', 'buscarInstituto', 'registrarInstituto'/*, 'logicalDelete'*/),
						'users' => array('@'),
						'roles' => array('RECEPCION'),
				),
				/*array('allow', // allow admin user to perform 'admin' and 'delete' actions
						'actions' => array('admin'),
						'users' => array('admin'),
				),*/
				array('deny',  // deny all users
						'users' => array('*'),
				),
		);
	}
	
	public function actionBuscarInstituto() {
		$institutoQueryForm = new InstitutoQueryForm();
		$institutoResult = array();
		$cinstituto = new CInstituto;
		if (isset($_POST['InstitutoQueryForm'])) {
			$institutoQueryForm->attributes = $_POST['InstitutoQueryForm'];
			
			$arrParams = array('no_instituto_search' => $institutoQueryForm->noInstituto);
			$institutoResult = $cinstituto->getInstitutosList($arrParams);
		}
		else {
			$arrParams = array();
			$institutoResult = $cinstituto->getInstitutosList($arrParams);
		}
		
		$lstInstitutoResult =  new CArrayDataProvider($institutoResult, array('keyField' => 'id_instituto', 'id' => 'lstInstitutoResult'));
		
		$this->render('schInstitucion', array('institutoQueryForm' => $institutoQueryForm, 'lstInstitutoResult' => $lstInstitutoResult));
	}
	
	
	
	
	public function actionRegistrarInstituto() {
		$cinstituto = new CInstituto;
		$institutoForm = new Instituto;
		if (isset($_POST['Instituto'])) {
			$institutoForm->attributes = $_POST['Instituto'];
			if (!$institutoForm->validate()) {
				header("Status: 500 Internal Server Error", true, 500);
				$validationResult = array();
				foreach($institutoForm->getErrors() as $attribute => $errors) {
					$validationResult[CHtml::activeId($visitaForm, $attribute)] = $errors;
				}
				$jsonResult = json_encode(array("message" => "Existen errores de validaciones. Verifique.", "validationResult" => $validationResult));
				echo $jsonResult;
				Yii::app()->end();//exit
			}
			else {
				try {
					$cinstituto->saveInstituto($institutoForm);
					echo json_encode(array("message" => "Grabado exitoso"));
				}
				catch (Exception $e) {
					error_log("exception::" . print_r($e, true));
					header("Status: 500 Internal Server Error", true, 500);
					echo json_encode(array("message" => "Hubo un error al guardar los datos. Tal vez estos datos ya se encuentren registrados en el sistema. Verifique."));
				}
				Yii::app()->end();//exit
			}
		}
		else {
			
		}
		
		
		
		
		$this->render('addInstitucion', array('institutoForm' => $institutoForm));
	}
}