<?php

class VisitaConsultaController extends Controller {
	
	const ID_CONSULTA_VISITA_WEB = 29;
	
	public $layout='//layouts/verysimple2';
	
	protected $cssContent = '
		<style type="text/css">
		<!--
		.grid-view table.items th {
		    background: url("css/bg_mod.gif") repeat-x scroll left top white;
		}
		
		#header {
		    border-top: 3px solid #4C99C5;
		}
		
		.grid-view table.items {
		    border: 1px solid #4C99C5;
		    border-collapse: separate;
		}
		-->
		</style>	
	';
	
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
				array('allow',  // allow all users to perform 'index' and 'view' actions
				 'actions' => array('index'),
						'users' => array('*'),
				),
				/*array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions' => array('index', 'deleteItemVisitaResultGrid', 'updateItemSalidaVisita', 'logicalDelete', 'update'),
						'users' => array('@'),
						'roles' => array('RECEPCION'),
				),*/
				array('deny',  // deny all users
						'users' => array('*'),
				),
		);
	}
	
	public function actionIndex() {
		/**
		 Leer el cookie, 
		 	si existe el cookie no contarlo
		 	si no existe el cookie, crearlo con expiracion de un dia, y contarlo
		 	
		 */
		$isNotActiveCookie = !isset(Yii::app()->request->cookies['counterConsultaVisitas']);
		if ($isNotActiveCookie) {
			$timeCurrent = time();
			$segundosRestantesDelDia = (mktime(23, 59, 59, date("n"), date("j"), date("Y")) - $timeCurrent);
			$objCookie = new CHttpCookie('counterConsultaVisitas', $segundosRestantesDelDia);
			$objCookie->expire = $timeCurrent + $segundosRestantesDelDia;
			try {
				$caccesoWeb = new CAccesoWeb();
				$caccesoWeb->countAccesoWeb(self::ID_CONSULTA_VISITA_WEB, date("Y-m-d"));
				Yii::app()->request->cookies['counterConsultaVisitas'] = $objCookie;
			}
			catch (Exception $e) {
				error_log("exception::" . print_r($e, true));
			}
		}
		/**
		 */
		$visitaConsultaQueryForm = new VisitaConsultaQueryForm();
		$cdominio = new CDominio();
		$cvisita = new CVisita();
		$visitaQueryForm = new VisitaQueryForm();
		$visitaQueryForm->inActivo = 7;//solo activos
		if (isset($_POST['VisitaConsultaQueryForm'])) {
			$visitaConsultaQueryForm->setAttributes($_POST['VisitaConsultaQueryForm']);
			$visitaQueryForm->feInicio = $visitaConsultaQueryForm->feConsulta;
			$visitaQueryForm->feTermino = $visitaConsultaQueryForm->feConsulta;
		}
		else {
			$visitaConsultaQueryForm->feConsulta = date('d/m/Y');
			$visitaQueryForm->feInicio = $visitaConsultaQueryForm->feConsulta;
			$visitaQueryForm->feTermino = $visitaConsultaQueryForm->feConsulta;
		}
		$arrParams = array('id_dominio' => 4, 'va_columna_01' => '7');
		$arrResult = $cdominio->getDominioDetalleList($arrParams);
		$strOrg = '';
		if (count($arrResult) > 0) {
			$strOrg = $arrResult[0]->no_detalle_dominio;
		}
		
		$lstVisitasConsultaResult =  new CArrayDataProvider($cvisita->getVisitaList($visitaQueryForm), array('keyField' => 'id_visita', 'id' => 'lstVisitasResult', 'pagination' => array('pageSize' => 15), 'sort'=>array('attributes'=>array('fe_ingreso', 'no_full_invitado', 'no_entidad_representada', 'no_lugar_reunion', 'no_full_colaborador', 'no_motivo_visita', 'no_full_documento',),),));
		$this->render('lstVisitasConsulta', array('visitaConsultaQueryForm' => $visitaConsultaQueryForm, 'lstVisitasConsultaResult' => $lstVisitasConsultaResult, 'noOrgEstatal' => $strOrg));
	}
	
	public function actionUpdateVisitasConsultaResultGrid() {
		$visitaConsultaQueryForm = new VisitaConsultaQueryForm();
		$cdominio = new CDominio();
		$cvisita = new CVisita();
		$visitaQueryForm = new VisitaQueryForm();
		$visitaQueryForm->inActivo = 7;//solo activos
		if (isset($_REQUEST['VisitaConsultaQueryForm'])) {
			$visitaConsultaQueryForm->setAttributes($_REQUEST['VisitaConsultaQueryForm']);
			$visitaQueryForm->feInicio = $visitaConsultaQueryForm->feConsulta;
			$visitaQueryForm->feTermino = $visitaConsultaQueryForm->feConsulta;
		}
		else {
			$visitaConsultaQueryForm->feConsulta = date('d/m/Y');
			$visitaQueryForm->feInicio = $visitaConsultaQueryForm->feConsulta;
			$visitaQueryForm->feTermino = $visitaConsultaQueryForm->feConsulta;
		}
		$lstVisitasConsultaResult =  new CArrayDataProvider($cvisita->getVisitaList($visitaQueryForm), array('keyField' => 'id_visita', 'id' => 'lstVisitasResult', 'pagination' => array('pageSize' => 15), 'sort'=>array('attributes'=>array('fe_ingreso', 'no_full_invitado', 'no_entidad_representada', 'no_lugar_reunion', 'no_full_colaborador', 'no_motivo_visita', 'no_full_documento',),),));
		$this->echoLstVisitasConsultaResultGrid($lstVisitasConsultaResult);
	}
	
	protected function echoLstVisitasConsultaResultGrid($lstVisitasConsultaResult) {
		$this->widget('zii.widgets.grid.CGridView', array(
				'id'=>'lst-visitas-consulta-result-grid',
				'dataProvider' => $lstVisitasConsultaResult,
				//'ajaxUpdate' => false,
				'ajaxUrl' => '',
				'pager' => array('maxButtonCount' => 5),
				'columns' => array(
						array('name' => 'fe_ingreso', 'type' => 'text', 'header' => 'FECHA'),
						'no_full_invitado:text:VISITANTE',
						'no_full_documento:text:DOCUMENTO',
						'no_entidad_representada:text:ENTIDAD',
						'no_motivo_visita:text:MOTIVO',
						'no_sede:text:SEDE',
						'no_full_colaborador:text:EMPLEADO PÚBLICO',
						//'no_cargo_laboral:text:OFICINA/CARGO',
						array('value' => '$data[\'no_oficina\'] . \' [\' . $data[\'no_cargo_laboral\'] . \']\'', 'type' => 'text', 'header' => 'OFICINA / CARGO'),
						'no_full_lugar_reunion:text:LUGAR DE REUNIÓN',
						'ho_ingreso:text:HORA ING.',
						'ho_salida:text:HORA SAL.',
				),
		));
	}
}