<?php

class DetalleDominioController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/standard';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('view','create','update','admin','delete'),
				'users'=>array('@'),
				'roles' => array('ADMIN'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array('model'=>$this->loadModel($id),));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$modelTable = null;
		$model=new DetalleDominio;
		if(isset($_GET['id_dominio'])) {
			$model->id_dominio = $_GET['id_dominio'];
			$modelTable = Dominio::model()->findByPk($_GET['id_dominio']);
		}
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['DetalleDominio']))
		{
			$model->attributes=$_POST['DetalleDominio'];
			if($model->save()) {
				$this->redirect(array('view','id'=>$model->id_detalle_dominio, 'id_dominio' => $model->id_dominio));
			}
		}

		$this->render('create',array('model'=>$model, 'modelTable' => $modelTable,));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$modelTable = null;
		$model = $this->loadModel($id);
		$modelTable = $model->objDominio;
		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['DetalleDominio']))
		{
			$model->attributes = $_POST['DetalleDominio'];
			if($model->save()) {
				$this->redirect(array('view','id'=>$model->id_detalle_dominio, 'id_dominio' => $model->id_dominio));
			}
		}

		$this->render('update',array('model'=>$model, 'modelTable' => $modelTable,));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax'])) {
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin','id_dominio' => $model->id_dominio));
			}
		}
		else {
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('DetalleDominio');
		$this->render('index',array('dataProvider'=>$dataProvider,));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$modelTable = null;
		$model=new DetalleDominio('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['id_dominio'])) {
			$model->id_dominio = $_GET['id_dominio'];
			$modelTable = Dominio::model()->findByPk($_GET['id_dominio']);
		}
		if(isset($_GET['DetalleDominio'])) {
			$model->attributes=$_GET['DetalleDominio'];
		}

		$this->render('admin',array('model'=>$model, 'modelTable' => $modelTable));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=DetalleDominio::model()->findByPk($id);
		if($model===null) {
			throw new CHttpException(404,'The requested page does not exist.');
		}
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='detalle-dominio-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}