<?php


class ContadorAccesoWebController extends Controller {
	
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/standard';
	
	const ID_CONSULTA_VISITA_WEB = 29;
	
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
				'accessControl', // perform access control for CRUD operations
		);
	}
	
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
				/*array('allow',  // allow all users to perform 'index' and 'view' actions
					'actions'=>array('index',),
						'users'=>array('*'),
				),*/
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
						'actions'=>array('view'),//,'create','update','admin','delete'
						'users'=>array('@'),
						'roles' => array('ADMIN'),
				),
				/*array('allow', // allow admin user to perform 'admin' and 'delete' actions
					'actions'=>array(),
						'users'=>array('admin'),
				),*/
				array('deny',  // deny all users
						'users'=>array('*'),
				),
		);
	}
	
	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView() {
		//grafico a 15 dias, desde el dia actual hasta hace 15 dias..

		$arrParams = array('tipoRecursoWeb' => self::ID_CONSULTA_VISITA_WEB, 'feAccesoWebIni' => date("Y-m-d", mktime(0, 0, 0, date("n"), date("j") - 15, date("Y"))), 'feAccesoWebFin' => date("Y-m-d"));
		$caccesoWeb = new CAccesoWeb();
		
		$lstResult = $caccesoWeb->getAccesoWebList($arrParams);
		
		$arrFechasAccesoWeb = array();
		foreach ($lstResult as $objAccesoWeb) {
			$arrFechasAccesoWeb[$objAccesoWeb->fe_acceso_web] = $objAccesoWeb->nu_acceso_web;
		}
		
		for ($iCount = 15; $iCount <= 0; $iCount--) {
			$dayCount = date("Y-m-d", mktime(0, 0, 0, date("n"), date("j") - $iCount, date("Y")));
			if (!isset($arrFechasAccesoWeb[$dayCount])) {
				$arrFechasAccesoWeb[$dayCount] = 0;
			}
			else {
				$arrFechasAccesoWeb[$dayCount] = (int) $arrFechasAccesoWeb[$dayCount];
			}
		}
	
		$this->render('view', array('arrFechasAccesoWeb' => $arrFechasAccesoWeb));
	}
}