<?php

class ColaboradorController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/standard';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			/*array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index',),
				'users'=>array('*'),
			),*/
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('view','create','update','admin','delete'),
				'users'=>array('@'),
				'roles' => array('ADMIN'),
			),
			/*array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array(),
				'users'=>array('admin'),
			),*/
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array('model'=>$this->loadModel($id),));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new Colaborador;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Colaborador']))
		{
			$model->attributes=$_POST['Colaborador'];
			if($model->save()) {
				$this->redirect(array('view','id'=>$model->id_colaborador));
			}
		}
		/*$crol = new CRol();
		$lstRol = array('' => '[Seleccione]') + CHtml::listData($crol->getRolList(array()), 'id_rol', 'no_rol');*/
		$ccargoLaboral = new CCargoLaboral();
		$lstCargoLaboral = array('' => '[Seleccione]') + CHtml::listData($ccargoLaboral->getCargoLaboralList(array()), 'id_cargo_laboral', 'no_cargo_laboral');
		$csede = new CSede();
		$lstSede = array('' => '[Seleccione]') + CHtml::listData($csede->getSedeList(array()), 'id_sede', 'no_sede');
		$cdominio = new CDominio();
		$lstTiDocumento = array('' => '[Seleccione]') + CHtml::listData($cdominio->getDominioDetalleList(array('id_dominio' => 1)), 'id_detalle_dominio', 'no_detalle_dominio');
		$coficina = new COficina();
		$lstOficina =  array('' => '[Seleccione]') + CHtml::listData($coficina->getOficinaList(array()), 'id_oficina', 'no_oficina');
		
		$this->render('create',array('model'=>$model, 'lstCargoLaboral' => $lstCargoLaboral, 'lstSede' => $lstSede, 'lstTiDocumento' => $lstTiDocumento, 'lstOficina' => $lstOficina));//'lstRol' => $lstRol, 
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Colaborador']))
		{
			$model->attributes=$_POST['Colaborador'];
			if($model->save()) {
				$this->redirect(array('view','id'=>$model->id_colaborador));
			}
		}
		$crol = new CRol();
		$lstRol = array('' => '[Seleccione]') + CHtml::listData($crol->getRolList(array()), 'id_rol', 'no_rol');
		$ccargoLaboral = new CCargoLaboral();
		$lstCargoLaboral = array('' => '[Seleccione]') + CHtml::listData($ccargoLaboral->getCargoLaboralList(array()), 'id_cargo_laboral', 'no_cargo_laboral');
		$csede = new CSede();
		$lstSede = array('' => '[Seleccione]') + CHtml::listData($csede->getSedeList(array()), 'id_sede', 'no_sede');
		$cdominio = new CDominio();
		$lstTiDocumento = array('' => '[Seleccione]') + CHtml::listData($cdominio->getDominioDetalleList(array('id_dominio' => 1)), 'id_detalle_dominio', 'no_detalle_dominio');
		$coficina = new COficina();
		$lstOficina =  array('' => '[Seleccione]') + CHtml::listData($coficina->getOficinaList(array()), 'id_oficina', 'no_oficina');
		
		$this->render('update',array('model'=>$model, 'lstRol' => $lstRol, 'lstCargoLaboral' => $lstCargoLaboral, 'lstSede' => $lstSede, 'lstTiDocumento' => $lstTiDocumento, 'lstOficina' => $lstOficina));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax'])) {
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
			}
		}
		else {
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
		}
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Colaborador');
		$this->render('index',array('dataProvider'=>$dataProvider,));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Colaborador('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Colaborador'])) {
			$model->attributes=$_GET['Colaborador'];
		}
		$ccargoLaboral = new CCargoLaboral();
		$lstCargoLaboral = array('' => '[Todos]') + CHtml::listData($ccargoLaboral->getCargoLaboralList(array()), 'id_cargo_laboral', 'no_cargo_laboral');
		$csede = new CSede;
		$lstSede = array('' => '[Todos]') + CHtml::listData($csede->getSedeList(array()), 'id_sede', 'no_sede');
		$this->render('admin',array('model'=>$model, 'lstCargoLaboral' => $lstCargoLaboral, 'lstSede' => $lstSede));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=Colaborador::model()->findByPk($id);
		if($model === null) {
			throw new CHttpException(404,'The requested page does not exist.');
		}
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='colaborador-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}