<?php

class SiteController extends Controller
{
	
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha'=>array(
				'class'=>'CCaptchaAction',
				'backColor'=>0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page'=>array(
				'class'=>'CViewAction',
			),
		);
	}

	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		//$this->render('index');
		$this->actionLogin();
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionError()
	{
	    if($error=Yii::app()->errorHandler->error)
	    {
	    	if(Yii::app()->request->isAjaxRequest)
	    		echo $error['message'];
	    	else
	        	$this->render('error', $error);
	    }
	}

	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model=new ContactForm;
		if(isset($_POST['ContactForm']))
		{
			$model->attributes=$_POST['ContactForm'];
			if($model->validate())
			{
				$headers="From: {$model->email}\r\nReply-To: {$model->email}";
				mail(Yii::app()->params['adminEmail'],$model->subject,$model->body,$headers);
				Yii::app()->user->setFlash('contact','Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact',array('model'=>$model));
	}

	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
		$model = new LoginForm;
		if(isset($_POST['ajax']) && $_POST['ajax'] === 'login-form')
		{
			// if it is ajax validation request
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		else if (isset($_POST['LoginForm']))
		{
			// collect user input data
			$model->attributes = $_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if($model->validate() && $model->login()) {
				//Yii::trace('validado', '*');
				/*if (isset(Yii::app()->user->returnUrl)) {
					//$this->redirect(Yii::app()->user->returnUrl);
				}
				else {
					$this->redirect(Yii::app()->user->returnUrl);
				}*/
				
				//crear el welcomeForm
				
				$welcomeForm = $this->createWelcomeForm();
				$this->render('welcome', array('welcomeForm' => $welcomeForm));
			}
			else {
				//Yii::trace('no validado', '*');
				// display the login form
				$this->render('login', array('model' => $model));
			}
		}
		else {
			if (Yii::app()->user->isGuest) {
				// display the login form
				$this->render('login', array('model' => $model));
			}
			else {
				$welcomeForm = $this->createWelcomeForm();
				$this->render('welcome', array('welcomeForm' => $welcomeForm));
			}
		}
	}
	
	private function createWelcomeForm() {
		$welcomeForm = new WelcomeForm();
		$hora = (int) date('HH');
		if ($hora > 24) {
			$welcomeForm->saludo = 'Buenas tardes';
		}
		else {
			$welcomeForm->saludo = 'Buenas días';
		}
		$welcomeForm->usuarioNombreCompleto = Yii::app()->user->nombres;
		$welcomeForm->feUltimoAcceso = Yii::app()->user->fe_login_ultimo;
		return $welcomeForm;
	}

	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
}