<?php

/**
 * UserIdentity represents the data needed to identity a user.
 * It contains the authentication method that checks if the provided
 * data can identity the user.
 */
class UserIdentity extends CUserIdentity
{
	/**
	 * Authenticates a user.
	 * The example implementation makes sure if the username and password
	 * are both 'demo'.
	 * In practical applications, this should be changed to authenticate
	 * against some persistent user identity storage (e.g. database).
	 * @return boolean whether authentication succeeds.
	 */
	public function authenticate()
	{
		/*$users=array(
			// username => password
			'demo'=>'demo',
			'admin'=>'admin',
		);*/
		
		$user = Usuario::model()->findByAttributes(array('no_usuario' => $this->username));
		//Yii::trace('param user:' . $this->username, '*');
		if ($user === null) {
			//Yii::trace('no user', '*');
			$this->errorCode = self::ERROR_USERNAME_INVALID;
		}
		else if($user->no_clave !== md5($this->password)) {
			//Yii::trace('users->no_clave = ' . $user->no_clave, '*');
			//Yii::trace('md5(this->password) = ' . md5($this->password), '*');
			$this->errorCode = self::ERROR_PASSWORD_INVALID;
		}
		else {
			//$this->setState("record", $user);
			//As you can see it stores the User record in the set stated option which is accessed in the application as follows: -
            //Yii::app()->user->record->first_name
			$this->setState("nombres", $user->no_completo_usuario . ' ' . $user->ap_paterno_usuario);
			$this->setState("no_usuario", $user->no_usuario);
			//$this->setState("co_user", $user->co_colaborador);
			$this->setState("id_sede", $user->objSede->id_sede);
			$this->setState("no_sede", $user->objSede->no_sede);
			$this->setState('roles', $user->objRol->co_rol);
			
			$user->fe_login_ultimo = $user->fe_login_actual;
			$user->fe_login_actual = date('Y-m-d H:i:s');
			$user->save();
			$this->setState("fe_login_ultimo", ($user->fe_login_ultimo? $user->fe_login_ultimo : ''));
			
			//we stored the user title information via $this->setState('title', $record->title);. Once we complete our login process, we can obtain the title information of the current user by simply using Yii::app()->user->title.
			$this->errorCode = self::ERROR_NONE;
		}
		return !$this->errorCode;
	}
}