<?php


/**
 * 
 * Formato de fechas para mysql
 * %d 	Day of the month, numeric (00..31)
 * %m 	Month, numeric (00..12)
 * %Y 	Year, numeric, four digits
 * 
 * %H 	Hour (00..23)
 * %i 	Minutes, numeric (00..59)
 * 
 *
 */
class CVisita extends CComponent {
	
	public function getVisita(array $arrParams) {
		$objResult = null;
		$arrCriterias = array();
		if (isset($arrParams['id_visita'])) {
			$arrCriterias['id_visita'] = $arrParams['id_visita'];
		}
		/*if (isset($arrParams['nu_documento'])) {
			$arrCriterias['nu_documento'] = $arrParams['nu_documento'];
		}*/
		$objResult = Visita::model()->findByAttributes($arrCriterias);//object of Visita model
		return $objResult;
	}
	
	public function getVisitaList($visitaQueryForm) {
		if ($visitaQueryForm->feInicio !== '' && $visitaQueryForm->feTermino !== '' && 
				$visitaQueryForm->feInicio != null && $visitaQueryForm->feTermino != null) {
			//error_log("visitaQueryForm->feInicio11::" . var_export($visitaQueryForm->feInicio, true));
			//error_log("visitaQueryForm->feTermino11::" . var_export($visitaQueryForm->feTermino, true));
		}
		else {
			//si viene vacio, llenarlo con la fecha actual
			$visitaQueryForm->feInicio = date('d/m/Y');
			$visitaQueryForm->feTermino = date('d/m/Y');
		}

		$usarRango = false;
		$fechaHora = '';
		if ($visitaQueryForm->feInicio !== $visitaQueryForm->feTermino) {
			$usarRango = false;
		}
		else {
			$usarRango = true;
			$fechaHora = $visitaQueryForm->feInicio;
		}
		$connection = Yii::app()->db;
		$driverName = $connection->getDriverName();
		$sqlVisita = "";
		if ($driverName == "mysql") {
			$sqlVisita = 
			"select 
				v.id_visita, 
	    		DATE_FORMAT(v.fe_ingreso, '%d/%m/%Y') 	as fe_ingreso,
	    		DATE_FORMAT(v.fe_salida, '%d/%m/%Y') 	as fe_salida,
	    		DATE_FORMAT(v.fe_ingreso, '%H:%i') 	as ho_ingreso,
	    		DATE_FORMAT(v.fe_salida, '%H:%i') 		as ho_salida,
	    		inv.no_invitado,
	    		inv.ap_paterno_invitado,
	    		inv.ap_materno_invitado,
	    		concat(inv.no_invitado, ' ', inv.ap_paterno_invitado, ' ', inv.ap_materno_invitado) as no_full_invitado,
	    		inv.ti_documento,
	    		dd.no_detalle_dominio as no_ti_documento,
	    		inv.nu_documento,
	    		concat(dd.no_detalle_dominio, ' ', inv.nu_documento) as no_full_documento,
	    		(case when (v.no_entidad_representada = '') then 'PARTICULAR' else (coalesce(v.no_entidad_representada, 'PARTICULAR')) end) as no_entidad_representada,
	    		v.no_motivo_visita,
	    		v.no_lugar_reunion,
	    		v.no_colaborador,
	    		v.ap_paterno_colaborador,
	    		v.ap_materno_colaborador,
	    		concat(v.no_colaborador, ' ', v.ap_paterno_colaborador, ' ', v.ap_materno_colaborador) as no_full_colaborador,
	    		v.no_cargo_laboral,
	    		v.no_oficina,
	    		(case when(v.no_lugar_reunion = 'OFICINA') then v.no_oficina else v.no_lugar_reunion end) as no_full_lugar_reunion,
				sed.no_sede as no_sede
			from
				tm_visita v,
				tm_invitado inv,
				td_detalle_dominio dd,
				tm_sede sed
			where 
				sed.id_sede = v.id_sede and
				dd.id_dominio = 1 and 
				dd.id_detalle_dominio = inv.ti_documento and 
				inv.id_invitado = v.id_invitado
			";
		}
		else if ($driverName == "pgsql") {
			$sqlVisita = 
			"select 
				v.id_visita, 
	    		to_char(v.fe_ingreso, 'DD/MM/YYYY') 	as fe_ingreso,
	    		to_char(v.fe_salida, 'DD/MM/YYYY') 	as fe_salida,
	    		to_char(v.fe_ingreso, 'HH24:MI') 	as ho_ingreso,
	    		to_char(v.fe_salida, 'HH24:MI') 		as ho_salida,
	    		inv.no_invitado,
	    		inv.ap_paterno_invitado,
	    		inv.ap_materno_invitado,
	    		(inv.no_invitado || ' ' || inv.ap_paterno_invitado || ' ' || inv.ap_materno_invitado) as no_full_invitado,
	    		inv.ti_documento,
	    		dd.no_detalle_dominio as no_ti_documento,
	    		inv.nu_documento,
	    		(dd.no_detalle_dominio || ' ' || inv.nu_documento) as no_full_documento,
	    		(case when (v.no_entidad_representada = '') then 'PARTICULAR' else (coalesce(v.no_entidad_representada, 'PARTICULAR')) end) as no_entidad_representada,
	    		v.no_motivo_visita,
	    		v.no_lugar_reunion,
	    		v.no_colaborador,
	    		v.ap_paterno_colaborador,
	    		v.ap_materno_colaborador,
	    		(v.no_colaborador || ' ' || v.ap_paterno_colaborador || ' ' || v.ap_materno_colaborador) as no_full_colaborador,
	    		v.no_cargo_laboral,
	    		v.no_oficina,
	    		(case when(v.no_lugar_reunion = 'OFICINA') then v.no_oficina else v.no_lugar_reunion end) as no_full_lugar_reunion,
				sed.no_sede as no_sede
			from
				tm_visita v,
				tm_invitado inv,
				td_detalle_dominio dd,
				tm_sede sed
			where 
				sed.id_sede = v.id_sede and
				dd.id_dominio = 1 and 
				dd.id_detalle_dominio = inv.ti_documento and 
				inv.id_invitado = v.id_invitado
			";
		}
		else if ($driverName == "mssql" || $driverName == "sqlsrv") {
			$sqlVisita = 
			"select 
				v.id_visita, 
	    		convert(varchar, v.fe_ingreso, 103) 	as fe_ingreso,
	    		convert(varchar, v.fe_salida, 103) 	as fe_salida,
	    		convert(varchar, v.fe_ingreso, 108) 	as ho_ingreso,
	    		convert(varchar, v.fe_salida, 108) 		as ho_salida,
	    		inv.no_invitado,
	    		inv.ap_paterno_invitado,
	    		inv.ap_materno_invitado,
	    		(inv.no_invitado + ' ' + inv.ap_paterno_invitado + ' ' + inv.ap_materno_invitado) as no_full_invitado,
	    		inv.ti_documento,
	    		dd.no_detalle_dominio as no_ti_documento,
	    		inv.nu_documento,
	    		(dd.no_detalle_dominio + ' ' + inv.nu_documento) as no_full_documento,
	    		(case when (v.no_entidad_representada = '') then 'PARTICULAR' else (coalesce(v.no_entidad_representada, 'PARTICULAR')) end) as no_entidad_representada,
	    		v.no_motivo_visita,
	    		v.no_lugar_reunion,
	    		v.no_colaborador,
	    		v.ap_paterno_colaborador,
	    		v.ap_materno_colaborador,
	    		(v.no_colaborador + ' ' + v.ap_paterno_colaborador + ' ' + v.ap_materno_colaborador) as no_full_colaborador,
	    		v.no_cargo_laboral,
	    		v.no_oficina,
	    		(case when(v.no_lugar_reunion = 'OFICINA') then v.no_oficina else v.no_lugar_reunion end) as no_full_lugar_reunion,
				sed.no_sede as no_sede
			from
				tm_visita v,
				tm_invitado inv,
				td_detalle_dominio dd,
				tm_sede sed
			where
				sed.id_sede = v.id_sede and 
				dd.id_dominio = 1 and 
				dd.id_detalle_dominio = inv.ti_documento and 
				inv.id_invitado = v.id_invitado
			";
		}

		
		$arrParams = array();
		if ($usarRango) {
			if ($driverName == "mysql") {
				$sqlVisita .= " and v.fe_ingreso >= str_to_date(:feInicio, '%d/%m/%Y') and v.fe_ingreso < (str_to_date(:feTermino, '%d/%m/%Y')) ";
			}
			else if ($driverName == "pgsql") {
				$sqlVisita .= " and v.fe_ingreso >= to_date(:feInicio, 'DD/MM/YYYY') and v.fe_ingreso < (to_date(:feTermino, 'DD/MM/YYYY')) ";
			}
			else if ($driverName == "mssql" || $driverName == "sqlsrv") {
				$sqlVisita .= " and v.fe_ingreso >= convert(datetime, :feInicio, 103) and v.fe_ingreso < (convert(datetime, :feTermino, 103)) ";
			}
			//$fechaHora //dd/mm/yyyy
			$arrFechaHora = explode("/", $fechaHora);
			$arrParams[':feInicio'] = array('data' => $fechaHora, 'tipo' => PDO::PARAM_STR,);
			$arrParams[':feTermino'] = array('data' => date("d/m/Y", mktime(0, 0, 0, $arrFechaHora[1], $arrFechaHora[0], $arrFechaHora[2]) + (24 * 60 * 60)), 'tipo' => PDO::PARAM_STR,);
			//error_log("fe termino:" . print_r($arrParams[':feTermino'], true));
		}
		else {
			if ($driverName == "mysql") {
				$sqlVisita .= " and v.fe_ingreso >= str_to_date(:feInicio, '%d/%m/%Y') and v.fe_ingreso < (str_to_date(:feTermino, '%d/%m/%Y')) ";
			}
			else if ($driverName == "pgsql") {
				$sqlVisita .= " and v.fe_ingreso >= to_date(:feInicio, 'DD/MM/YYYY') and v.fe_ingreso < (to_date(:feTermino, 'DD/MM/YYYY')) ";
			}
			else if ($driverName == "mssql" || $driverName == "sqlsrv") {
				$sqlVisita .= " and v.fe_ingreso >= convert(datetime, :feInicio, 103) and v.fe_ingreso < (convert(datetime, :feTermino, 103)) ";
			}
			$arrFechaHora = explode("/", $visitaQueryForm->feTermino);
			$arrParams[':feInicio'] = array('data' => $visitaQueryForm->feInicio, 'tipo' => PDO::PARAM_STR,);
			$arrParams[':feTermino'] = array('data' => date("d/m/Y", mktime(0, 0, 0, $arrFechaHora[1], $arrFechaHora[0], $arrFechaHora[2]) + (24 * 60 * 60)), 'tipo' => PDO::PARAM_STR,);
		}
		
		if ($visitaQueryForm->nuDocumento != '') {
			$sqlVisita .= " and inv.nu_documento like :nuDocumento ";
			$arrParams[':nuDocumento'] = array('data' => $visitaQueryForm->nuDocumento . '%', 'tipo' => PDO::PARAM_STR);
		}

		if ($visitaQueryForm->noInstitucion != '') {
			$sqlVisita .= " and v.no_entidad_representada like :noInstitucion ";
			$arrParams[':noInstitucion'] = array('data' => '%' . $visitaQueryForm->noInstitucion . '%', 'tipo' => PDO::PARAM_STR);
		}
		
		if ($visitaQueryForm->noInvitado != '') {
			$sqlVisita .= " and inv.no_invitado like :noInvitado ";
			$arrParams[':noInvitado'] = array('data' => '%' . $visitaQueryForm->noInvitado . '%', 'tipo' => PDO::PARAM_STR);
		}
		
		if ($visitaQueryForm->apInvitado != '') {
			if ($driverName == "mysql") {
				$sqlVisita .= " and concat(inv.ap_paterno_invitado, ' ', inv.ap_materno_invitado) like :apInvitado ";
			}
			else if ($driverName == "pgsql") {
				$sqlVisita .= " and (inv.ap_paterno_invitado || ' ' || inv.ap_materno_invitado) like :apInvitado ";
			}
			else if ($driverName == "mssql" || $driverName == "sqlsrv") {
				$sqlVisita .= " and (inv.ap_paterno_invitado + ' ' + inv.ap_materno_invitado) like :apInvitado ";
			}
			$arrParams[':apInvitado'] = array('data' => '%' . $visitaQueryForm->apInvitado . '%', 'tipo' => PDO::PARAM_STR);
		}
		
		if ($visitaQueryForm->noColaborador != '') {
			$sqlVisita .= " and v.no_colaborador like :noColaborador ";
			$arrParams[':noColaborador'] = array('data' => '%' . $visitaQueryForm->noColaborador . '%', 'tipo' => PDO::PARAM_STR);
		}
		
		if ($visitaQueryForm->apColaborador != '') {
			if ($driverName == "mysql") {
				$sqlVisita .= " and concat(v.ap_paterno_colaborador, ' ', v.ap_materno_colaborador) like :apColaborador ";
			}
			else if ($driverName == "pgsql") {
				$sqlVisita .= " and (v.ap_paterno_colaborador || ' ' || v.ap_materno_colaborador) like :apColaborador ";
			}
			else if ($driverName == "mssql" || $driverName == "sqlsrv") {
				$sqlVisita .= " and (v.ap_paterno_colaborador + ' ' + v.ap_materno_colaborador) like :apColaborador ";
			}
			$arrParams[':apColaborador'] = array('data' => '%' . $visitaQueryForm->apColaborador . '%', 'tipo' => PDO::PARAM_STR);
		}

		if ($visitaQueryForm->noLugarReunion != '') {
			$sqlVisita .= " and v.no_lugar_reunion like :noLugarReunion ";
			$arrParams[':noLugarReunion'] = array('data' => '%' . $visitaQueryForm->noLugarReunion . '%', 'tipo' => PDO::PARAM_STR);
		}
		if ($visitaQueryForm->inActivo != '') {
			$sqlVisita .= " and v.in_activo = :inActivo ";
			$arrParams[':inActivo'] = array('data' => $visitaQueryForm->inActivo, 'tipo' => PDO::PARAM_INT);
		}
		if ($visitaQueryForm->idSede != '') {
			$sqlVisita .= " and v.id_sede = :idSede ";
			$arrParams[':idSede'] = array('data' => $visitaQueryForm->idSede, 'tipo' => PDO::PARAM_INT);
		}
		
		$sqlVisita .= " order by v.fe_ingreso desc";
		
		/*error_log($sqlVisita);*/

		$command = $connection->createCommand($sqlVisita);
		$command->setFetchMode(PDO::FETCH_ASSOC);

		foreach ($arrParams AS $keyParam => $arrData) {
			$command->bindParam($keyParam, $arrData['data'], $arrData['tipo']);
		}
		
		/*$dataReader = $command->query();
		
		var $list = array();
		foreach($dataReader as $row) {
			$list[] = $row;
		}*/
		return $command->queryAll();
	}
	
	public function saveVisita($visitasForm) {
		
		$lstTmpVisitaInvitados =& $visitasForm->lstVisitaInvitados;
		//error_log("count lstTmpVisitaInvitados::" . count($lstTmpVisitaInvitados));
		$transaction = Yii::app()->db->beginTransaction();
		try {
			if (count($lstTmpVisitaInvitados) == 0) {
				throw new Exception("La lista de invitados está vacía. Verifique.");
			}
			foreach ($lstTmpVisitaInvitados as $visitaInvitadoForm) {
				$invitado = new Invitado();
				$visita = new Visita();
				$idInvitado = 0;
				if ($visitaInvitadoForm->idInvitado != '') {
					//actualizar la institucion por donde viene
					$idInvitado = $visitaInvitadoForm->idInvitado;
					$invitado = Invitado::model()->findByPk($visitaInvitadoForm->idInvitado);
					$invitado->no_invitado = $visitaInvitadoForm->noInvitado;
					$invitado->ap_paterno_invitado = $visitaInvitadoForm->apPaternoInvitado;
					$invitado->ap_materno_invitado = $visitaInvitadoForm->apMaternoInvitado;
					$invitado->ti_documento = $visitaInvitadoForm->tiDocumento;
					$invitado->nu_documento = $visitaInvitadoForm->nuDocumento;
					$invitado->no_entidad_representada = $visitaInvitadoForm->noInstitucion;
					$invitado->save();
				}
				else {
					$invitado->no_invitado = $visitaInvitadoForm->noInvitado;
					$invitado->ap_paterno_invitado = $visitaInvitadoForm->apPaternoInvitado;
					$invitado->ap_materno_invitado = $visitaInvitadoForm->apMaternoInvitado;
					$invitado->ti_documento = $visitaInvitadoForm->tiDocumento;
					$invitado->nu_documento = $visitaInvitadoForm->nuDocumento;
					$invitado->no_entidad_representada = $visitaInvitadoForm->noInstitucion;
					
					//si la validacion falla, debido a un campo vacio en la clase, esta no va a insertarse y solo devolverá false.
					$strMensaje = '';
					if (!$invitado->save()) {
						foreach($invitado->getErrors() as $attribute => $errors) {
							$strMensaje = 'El campo ' . CHtml::activeName($invitado, $attribute) . ' presenta que ' . implode(' ', $errors);
						}
						throw new Exception($strMensaje);
					}
					
					$idInvitado = $invitado->id_invitado;
				}
				$colaborador = Colaborador::model()->findByPk($visitasForm->idColaborador);
				$visita->id_invitado = $idInvitado;
				//$visita->id_colaborador = $visitasForm->idColaborador;
				$visita->no_lugar_reunion = $visitasForm->noLugarReunion;
				$visita->no_cargo_laboral = $colaborador->objCargoLaboral->no_cargo_laboral;
				
				$visita->no_colaborador = $colaborador->no_colaborador;
				$visita->ap_paterno_colaborador = $colaborador->ap_paterno_colaborador;
				$visita->ap_materno_colaborador = $colaborador->ap_materno_colaborador;
				$visita->ti_documento_colaborador = $colaborador->ti_documento;
				$visita->nu_documento_colaborador = $colaborador->nu_documento;
				
				if (isset($colaborador->objOficina) && isset($colaborador->objOficina->no_oficina) /*&& $visita->no_lugar_reunion == 'OFICINA'*/) {
					$visita->no_oficina = $colaborador->objOficina->no_oficina;
				}
				
				$visita->no_motivo_visita = $visitasForm->noMotivo;
				$visita->no_entidad_representada = $visitaInvitadoForm->noInstitucion;
				$visita->fe_registro = date('Y-m-d H:i:s');
				$arrFeIngreso = explode('/', $visitasForm->feIngreso);
				$arrHoIngreso = explode(':', $visitasForm->hoIngreso);
				/*$nuTimeDosDias = mktime(0, 0, 0, date('n'), date('j') - 2, date('Y'));
				$nuTimeIngreso = mktime(0, 0, 0, $arrFeIngreso[1], $arrFeIngreso[0], $arrFeIngreso[2]);
				if (!($nuTimeDosDias >= $nuTimeIngreso)) {
					throw new Exception("La fecha . Verifique.");
				}*/
				$visita->fe_ingreso = date('Y-m-d H:i:s', mktime($arrHoIngreso[0], $arrHoIngreso[1], 0, $arrFeIngreso[1], $arrFeIngreso[0], $arrFeIngreso[2])); //$visitasForm->hoIngreso;//d/m/Y
				
				$visita->co_pase = $visitaInvitadoForm->coPase;
				$visita->in_activo = 7;//activo
				$visita->id_sede = $visitasForm->idSede;
				$visita->no_usuario_registro = $visitasForm->noUsuarioResgistro;
				
				//si la validacion falla, debido a un campo vacio en la clase, esta no va a insertarse y solo devolverá false.
				$strMensaje = '';
				if (!$visita->save()) {
					foreach($visita->getErrors() as $attribute => $errors) {
						$strMensaje = 'El campo ' . CHtml::activeName($visita, $attribute) . ' presenta que ' . implode(' ', $errors); 
					}
					throw new Exception($strMensaje);
				}
			}
			$transaction->commit();
		}
		catch (Exception $e) {
			$transaction->rollBack();
			throw $e;
		}
	}
	
	public function updateVisitas($arrParams) {
		if (isset($arrParams['arrVisitas']) && is_array($arrParams['arrVisitas']) && count($arrParams['arrVisitas']) > 0) {
			$transaction = Yii::app()->db->beginTransaction();
			try {
				foreach ($arrParams['arrVisitas'] as $objVisita) {
					$objVisita->save();
				}
				$transaction->commit();
			}
			catch (Exception $e) {
				$transaction->rollBack();
				throw $e;
			}
		}
	}
	
	public function deleteVisitas(array $arrParams) {
		$transaction = Yii::app()->db->beginTransaction();
		try {
			$conditions = "";
			if (isset($arrParams['arrIdVisitas']) && is_array($arrParams['arrIdVisitas']) && count($arrParams['arrIdVisitas']) > 0) {
				//id_visita in ()
				$conditions .= "id_visita in (";
				for ($i = 0; $i < count($arrParams['arrIdVisitas']); $i++) {
					$idVisita = $arrParams['arrIdVisitas'][$i];
					$conditions .= $idVisita;
					if ($i != count($arrParams['arrIdVisitas']) - 1) {
						$conditions .= ",";
					}
				}
				$conditions .= ")";
			}
			
			Visita::model()->deleteAll($conditions);
			$transaction->commit();
		}
		catch (Exception $e) {
			$transaction->rollBack();
			throw $e;
		}
	}
}