<?php


class CRoleBasedWebUser extends CWebUser {
	
	public function checkAccess($operation, $params = array()) {
		if (empty($this->id)) {
			// Not identified => no rights
			return false;
		}
		
		$role = $this->getState("roles");
		//error_log("operation::" . $operation);
		//error_log("role::" . $role);
		if ($role === 'ADMIN') {
			return true; // admin role has access to everything
		}
		// allow access if the operation request is the current user's role
		return ($operation === $role);
	}
}