<?php
class CInstituto extends CComponent {

	public function getInstitutosList(array $arrParams) {
		$arrResult = array();
		$arrCriterias = array();
		$arrPreParams = array();
		if (isset($arrParams['no_instituto_search']) && $arrParams['no_instituto_search'] != '') {
			$arrCriterias['condition'] = 'no_instituto like :no_instituto_search';
			$arrPreParams[':no_instituto_search'] = '%' . $arrParams['no_instituto_search'] . '%';
		}
		if (count($arrCriterias) == 0) {
			//$arrCriterias['limit'] = 20;
		}
		$arrCriterias['order'] = 'no_instituto ASC';
		
		$arrCriterias['params'] = $arrPreParams;//si $arrCriterias es array, tonces poner un key 'params' dentro de ello para los parametros..
		
		$arrResult = Instituto::model()->findAll($arrCriterias, $arrPreParams);
		
		return $arrResult;
	}
	
	
	public function saveInstituto($instituto) {
		$instituto->save();
	}
	
}