<?php

class CColaborador extends CComponent {
	
	public function getColaboradoresList(array $arrParams) {
		$arrResult = array();
		$arrCriterias = array();
		if (isset($arrParams['searchNombreCompleto'])) {
			$connection = Yii::app()->db;
			$driverName = $connection->getDriverName();
			if ($driverName == "mysql") {
				$strQuery = "select col.*,cl.no_cargo_laboral,o.no_oficina from tm_colaborador col 
					left join tm_cargo_laboral cl
					on	col.id_cargo_laboral = cl.id_cargo_laboral
					left join tm_oficina o
					on	col.id_oficina = o.id_oficina
					where concat(col.no_colaborador,' ', col.ap_paterno_colaborador, ' ', col.ap_materno_colaborador) like :searchNombreCompleto";
			}
			else if ($driverName == "pgsql") {
				$strQuery = "select col.* from tm_colaborador col where (col.no_colaborador || ' ' || col.ap_paterno_colaborador || ' ' || col.ap_materno_colaborador) like :searchNombreCompleto";
			}
			else if ($driverName == "mssql" || $driverName == "sqlsrv") {
				$strQuery = "select col.* from tm_colaborador col where (col.no_colaborador + ' ' + col.ap_paterno_colaborador + ' ' + col.ap_materno_colaborador) like :searchNombreCompleto";
			}
			
			$arrCriterias[':searchNombreCompleto'] = '%' . $arrParams['searchNombreCompleto'] . '%';
			if (isset($arrParams['id_sede'])) {
				$strQuery .= " and (col.id_sede = :idSede";
				$arrCriterias[':idSede'] = $arrParams['id_sede'];
				if (!isset($arrParams['dni_excepciones'])) {
					$strQuery .= ")";
				}
			}
			if (isset($arrParams['dni_excepciones'])) {
				$strQuery .= " or ";
				if (is_array($arrParams['dni_excepciones'])) {
					$strQuery .= " col.nu_documento in ('" . implode("','", $arrParams['dni_excepciones']) ."') ";
				}
				else {
					$strQuery .= " col.nu_documento = '" . $arrParams['dni_excepciones'] . "' ";
				}
				$strQuery .= ")";
			}
			$arrResult = Colaborador::model()->findAllBySql($strQuery, $arrCriterias);
			return $arrResult;
		}
		if (isset($arrParams['id_colaborador']) || isset($arrParams['id_sede'])) {
			if (isset($arrParams['id_colaborador'])) {
				$arrCriterias['id_colaborador'] = $arrParams['id_colaborador'];
			}
			if (isset($arrParams['id_sede'])) {
				$arrCriterias['id_sede'] = $arrParams['id_sede'];
			}
			$arrResult = Colaborador::model()->findAllByAttributes($arrCriterias);//array of Colaboradores models
			return $arrResult;
		}
	}
}