<?php


class CAccesoWeb extends CComponent {
	
	public function countAccesoWeb($tipoRecursoWeb, $feAccesoWeb) {
		$arrParams = array('feAccesoWeb' => $feAccesoWeb, 'tipoRecursoWeb' => $tipoRecursoWeb);
		$objAccesoWeb = $this->getAccesoWeb($arrParams);
		if ($objAccesoWeb == null) {
			$objAccesoWeb = new AccesoWeb();
			$objAccesoWeb->ti_recurso_web = $tipoRecursoWeb;
			$objAccesoWeb->fe_acceso_web = $feAccesoWeb;
			$objAccesoWeb->nu_acceso_web = 0;
		}
		$objAccesoWeb->nu_acceso_web = $objAccesoWeb->nu_acceso_web + 1;
		$objAccesoWeb->save();
	}
	
	public function getAccesoWeb(array $arrParams) {
		$objResult = null;
		$arrCriterias = array();
		if (isset($arrParams['tipoRecursoWeb'])) {
			$arrCriterias['ti_recurso_web'] = $arrParams['tipoRecursoWeb'];
		}
		if (isset($arrParams['feAccesoWeb'])) {//yyyy-mm-dd
			$arrCriterias['fe_acceso_web'] = $arrParams['feAccesoWeb'];
		}
		
		$objResult = AccesoWeb::model()->findByAttributes($arrCriterias);//object of Visita model
		return $objResult;
	}
	
	public function getAccesoWebList(array $arrParams) {
		$lstResult = null;
		$objCriteria = new CDbCriteria(array('order' => 'fe_acceso_web DESC'));
		
		if (isset($arrParams['tipoRecursoWeb'])) {
			$objCriteria->addCondition("ti_recurso_web = :tipoRecursoWeb", "AND");
			$objCriteria->params[":tipoRecursoWeb"] = $arrParams['tipoRecursoWeb'];
		}
		if (isset($arrParams['feAccesoWebIni'])) {//yyyy-mm-dd
			$objCriteria->addCondition("fe_acceso_web >= :feAccesoWebIni", "AND");
			$objCriteria->params[":feAccesoWebIni"] = $arrParams['feAccesoWebIni'];
		}
		if (isset($arrParams['feAccesoWebFin'])) {//yyyy-mm-dd
			$objCriteria->addCondition("fe_acceso_web <= :feAccesoWebFin", "AND");
			$objCriteria->params[":feAccesoWebFin"] = $arrParams['feAccesoWebFin'];
		}
		
		$lstResult = AccesoWeb::model()->findAll($objCriteria);//listado de objetos AccesoWeb
		
		return $lstResult;
	}
}